(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     21002,        680]
NotebookOptionsPosition[     17726,        563]
NotebookOutlinePosition[     18084,        579]
CellTagsIndexPosition[     18041,        576]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Kugel", "Subtitle",
 CellChangeTimes->{{3.5514277705223513`*^9, 3.551427774199285*^9}}],

Cell[BoxData[
 RowBox[{"UKugel", " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"0.311", "+", "0.320"}], ")"}], "*", "0.5"}]}]], "Input",
 CellChangeTimes->{{3.551427801659339*^9, 3.551427829888721*^9}, {
  3.551427885191133*^9, 3.551427891926764*^9}}],

Cell[BoxData[
 RowBox[{"MKugel", " ", ":=", "0.348"}]], "Input",
 CellChangeTimes->{{3.551427822964884*^9, 3.551427842463971*^9}}],

Cell[BoxData[
 RowBox[{"sMKugel", " ", ":=", "0.002"}]], "Input",
 CellChangeTimes->{{3.551433630070259*^9, 3.551433633860314*^9}, {
  3.5514336851790047`*^9, 3.5514336863788567`*^9}, {3.5514338807815447`*^9, 
  3.551433883021348*^9}, {3.55143557497283*^9, 3.551435577147725*^9}}],

Cell[BoxData[
 RowBox[{"sUKugel", " ", ":=", "0.01"}]], "Input",
 CellChangeTimes->{{3.5514337042577353`*^9, 3.55143372109801*^9}, {
  3.551433786160124*^9, 3.551433796999854*^9}, {3.551433949179302*^9, 
  3.551433954654607*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JKugel", " ", "=", " ", 
  RowBox[{
   FractionBox["2", "5"], "MKugel", "*", 
   RowBox[{
    RowBox[{"(", 
     FractionBox["UKugel", 
      RowBox[{"2", "\[Pi]"}]], ")"}], "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.551427777031118*^9, 3.551427793777451*^9}, {
  3.551427847527754*^9, 3.5514278643355303`*^9}}],

Cell[BoxData["0.0003509766510618866`"], "Output",
 CellChangeTimes->{{3.551427857847761*^9, 3.5514278647904377`*^9}, 
   3.5514278961064997`*^9, 3.551428168373158*^9, 3.551433805681592*^9, 
   3.5514338930046873`*^9, 3.551433934698944*^9, 3.551454591526636*^9, 
   3.5514613447198477`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    FractionBox["0.86", 
     RowBox[{"2", "\[Pi]"}]], ")"}], "^", "2"}], "*", 
  FractionBox["360", 
   RowBox[{"2", "\[Pi]"}]], 
  FractionBox["1", "3011"]}]], "Input",
 CellChangeTimes->{{3.5514617505881443`*^9, 3.551461774727707*^9}, {
  3.5514618187042313`*^9, 3.551461845086319*^9}}],

Cell[BoxData["0.0003564913879129013`"], "Output",
 CellChangeTimes->{{3.551461758724104*^9, 3.551461775261887*^9}, {
  3.551461829159821*^9, 3.551461845630982*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJKugel", " ", "=", " ", 
  RowBox[{
   FractionBox["2", "5"], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"sMKugel", "*", 
        RowBox[{
         RowBox[{"(", 
          FractionBox["UKugel", 
           RowBox[{"2", "\[Pi]"}]], ")"}], "^", "2"}]}], ")"}], "^", "2"}], 
     "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "\[Pi]"], "*", "MKugel", "*", 
        FractionBox["UKugel", 
         RowBox[{"2", "\[Pi]"}]], "*", "sUKugel"}], ")"}], "^", "2"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5514334701350183`*^9, 3.551433557176137*^9}, {
  3.551433605271678*^9, 3.551433623927547*^9}, {3.55143373983626*^9, 
  3.551433740108204*^9}, {3.551435818523593*^9, 3.551435820103804*^9}}],

Cell[BoxData["0.00002234016535007022`"], "Output",
 CellChangeTimes->{
  3.551433625029171*^9, {3.551433728102769*^9, 3.551433740755259*^9}, 
   3.55143380705755*^9, 3.551433893043243*^9, {3.5514339374706993`*^9, 
   3.5514339566322603`*^9}, 3.5514358213462467`*^9, 3.551454591577791*^9, 
   3.551461344774599*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"sigmaM", " ", ":=", "0.002"}], "\[IndentingNewLine]", 
 RowBox[{"sigmaD", ":=", "0.001"}]}], "Input",
 CellChangeTimes->{{3.551435561466319*^9, 3.551435620539526*^9}}],

Cell[BoxData[
 RowBox[{"DZylinder", " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"0.079", "+", "0.079"}], ")"}], "/", "2"}]}]], "Input",
 CellChangeTimes->{{3.551427869257965*^9, 3.5514279147979717`*^9}}],

Cell[BoxData[
 RowBox[{"MZylinder", " ", ":=", "0.298"}]], "Input",
 CellChangeTimes->{{3.551427924534957*^9, 3.551427933053198*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JZylinder", "=", 
  RowBox[{
   FractionBox["1", "2"], "MZylinder", "*", 
   RowBox[{
    RowBox[{"(", 
     FractionBox["DZylinder", "2"], ")"}], "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.551427935576291*^9, 3.551427966132986*^9}}],

Cell[BoxData["0.00023247724999999998`"], "Output",
 CellChangeTimes->{3.5514279671893873`*^9, 3.551428168472228*^9, 
  3.551433893168808*^9, 3.551454591704821*^9, 3.5514613449023046`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJZylinder", " ", "=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"sigmaM", "*", 
        RowBox[{
         RowBox[{"(", 
          FractionBox["DZylinder", "2"], ")"}], "^", "2"}]}], ")"}], "^", 
      "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"MZylinder", "*", 
        FractionBox["DZylinder", "2"], "*", "sigmaD"}], ")"}], "^", "2"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5514356389055223`*^9, 3.551435655591083*^9}, {
  3.551435799258999*^9, 3.551435809104269*^9}, {3.5514358818865643`*^9, 
  3.5514358856544323`*^9}}],

Cell[BoxData["6.0888004001198795`*^-6"], "Output",
 CellChangeTimes->{3.5514358865857897`*^9, 3.551454591742251*^9, 
  3.5514613449551563`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"DScheibe", " ", ":=", " ", "0.162"}]], "Input",
 CellChangeTimes->{{3.551427976572761*^9, 3.551427987451535*^9}}],

Cell[BoxData[
 RowBox[{"MScheibe", " ", ":=", "0.400"}]], "Input",
 CellChangeTimes->{{3.551427988709564*^9, 3.55142800487507*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JScheibe", " ", "=", " ", 
  RowBox[{
   FractionBox["1", "2"], "MScheibe", "*", 
   RowBox[{
    RowBox[{"(", 
     FractionBox["DScheibe", "2"], ")"}], "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.551428006528117*^9, 3.5514280383394136`*^9}}],

Cell[BoxData["0.0013122000000000001`"], "Output",
 CellChangeTimes->{3.5514280386881933`*^9, 3.551428168571537*^9, 
  3.551433893268792*^9, 3.551454591856845*^9, 3.551461345068906*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJScheibe", " ", "=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"sigmaM", "*", 
        RowBox[{
         RowBox[{"(", 
          FractionBox["DScheibe", "2"], ")"}], "^", "2"}]}], ")"}], "^", 
      "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"MScheibe", "*", 
        FractionBox["DScheibe", "2"], "*", "sigmaD"}], ")"}], "^", "2"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.551435926494994*^9, 3.55143592810914*^9}, {
  3.5514361489925632`*^9, 3.551436162006455*^9}}],

Cell[BoxData["0.00001747817842339413`"], "Output",
 CellChangeTimes->{{3.551436144388318*^9, 3.551436163235876*^9}, 
   3.5514545918928013`*^9, 3.551461345108471*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"MHohlzylinder", " ", ":=", "0.193"}]], "Input",
 CellChangeTimes->{{3.5514280592482643`*^9, 3.551428069441408*^9}}],

Cell[BoxData[
 RowBox[{"D1Hohlzylinder", " ", ":=", " ", "0.086"}]], "Input",
 CellChangeTimes->{{3.551428071135543*^9, 3.5514280794493723`*^9}, {
  3.551428130536381*^9, 3.551428130655542*^9}}],

Cell[BoxData[
 RowBox[{"D2Hohlzylinder", " ", ":=", "0.0995"}]], "Input",
 CellChangeTimes->{{3.551428081280943*^9, 3.5514280871448507`*^9}, {
  3.5514281324400473`*^9, 3.55142813252747*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JHohlzylinder", " ", "=", " ", 
  RowBox[{
   FractionBox["1", "2"], "*", "MHohlzylinder", "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       FractionBox["D2Hohlzylinder", "2"], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       FractionBox["D1Hohlzylinder", "2"], ")"}], "^", "2"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.551428090779912*^9, 3.551428170962867*^9}, 
   3.551430995171755*^9, {3.551431205654107*^9, 3.551431205892116*^9}}],

Cell[BoxData["0.00041727203125`"], "Output",
 CellChangeTimes->{
  3.551428171261127*^9, 3.551430998750949*^9, {3.551431208470819*^9, 
   3.551431214914938*^9}, 3.551433893383971*^9, 3.5514545920392237`*^9, 
   3.551461345233886*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJHohlzylinder", " ", "=", 
  RowBox[{
   FractionBox["1", "2"], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"sigmaM", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             FractionBox["D2Hohlzylinder", "2"], ")"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             FractionBox["D1Hohlzylinder", "2"], ")"}], "^", "2"}]}], ")"}]}],
         ")"}], "^", "2"}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"MHohlzylinder", "*", 
         RowBox[{"(", 
          FractionBox["D1Hohlzylinder", "2"], ")"}], "*", "sigmaD"}], ")"}], 
       "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"MHohlzylinder", "*", 
        RowBox[{"(", 
         FractionBox["D2Hohlzylinder", "2"], ")"}], "*", "sigmaD"}], ")"}], 
      "^", "2"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.551436879530542*^9, 3.551436888713739*^9}, {
  3.551453662964872*^9, 3.5514537408593483`*^9}}],

Cell[BoxData["4.800875000134118`*^-6"], "Output",
 CellChangeTimes->{
  3.5514368896858892`*^9, {3.55145374276206*^9, 3.551453760461214*^9}, 
   3.551454592074628*^9, 3.551461345293066*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DHantelk\[ODoubleDot]rper", " ", "=", "0.3695"}]], "Input",
 CellChangeTimes->{{3.5514314265323687`*^9, 3.551431459482389*^9}}],

Cell[BoxData["0.3695`"], "Output",
 CellChangeTimes->{{3.551431441830283*^9, 3.5514314599792013`*^9}, 
   3.5514338934260883`*^9, 3.551454592124509*^9, 3.551461345338962*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MHantelk\[ODoubleDot]rper", " ", "=", "0.053"}]], "Input",
 CellChangeTimes->{{3.551431468293159*^9, 3.5514314770420732`*^9}}],

Cell[BoxData["0.053`"], "Output",
 CellChangeTimes->{3.551431477696417*^9, 3.551433893473728*^9, 
  3.551454592173993*^9, 3.551461345387846*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MHantel", " ", "=", "0.200"}]], "Input",
 CellChangeTimes->{{3.5514314784553547`*^9, 3.551431483770015*^9}}],

Cell[BoxData["0.2`"], "Output",
 CellChangeTimes->{3.551431484122059*^9, 3.5514338935222692`*^9, 
  3.551454592225124*^9, 3.551461345438714*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JHantel", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      FractionBox["1", "12"], "MHantel"}], "+", 
     RowBox[{
      FractionBox["2", "6"], " ", "MHantelk\[ODoubleDot]rper"}]}], ")"}], "*", 
   SuperscriptBox["DHantelk\[ODoubleDot]rper", "2"], " "}]}]], "Input",
 CellChangeTimes->{{3.551431485794402*^9, 3.551431489473805*^9}, {
   3.55143240640897*^9, 3.551432453207196*^9}, {3.5514324854156437`*^9, 
   3.5514325155220757`*^9}, 3.5514538340719233`*^9, {3.551453915500742*^9, 
   3.5514539662543087`*^9}, {3.551454012005396*^9, 3.551454044525013*^9}}],

Cell[BoxData["0.004687538583333332`"], "Output",
 CellChangeTimes->{{3.551432502951304*^9, 3.5514325160348673`*^9}, 
   3.5514338935721703`*^9, {3.55145402399378*^9, 3.551454047538513*^9}, 
   3.551454139229905*^9, 3.5514545922763023`*^9, 3.551461345487341*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJHantel", "=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "12"], "MHantel"}], "+", 
         RowBox[{
          FractionBox["2", "6"], " ", "MHantelk\[ODoubleDot]rper"}]}], ")"}], 
       "*", "DHantelk\[ODoubleDot]rper", "*", "sigmaD"}], " ", ")"}], "^", 
     "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["2", "6"], " ", "sigmaM", "*", 
       SuperscriptBox["DHantelk\[ODoubleDot]rper", "2"]}], " ", ")"}], "^", 
     "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "12"], "sigmaM", "*", 
       SuperscriptBox["DHantelk\[ODoubleDot]rper", "2"]}], " ", ")"}], "^", 
     "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5514537960978613`*^9, 3.551453814379085*^9}, {
  3.551453877689171*^9, 3.551453878824888*^9}, {3.551454060641459*^9, 
  3.551454116333593*^9}, {3.551461063881228*^9, 3.551461064047571*^9}}],

Cell[BoxData["0.00009467524220182356`"], "Output",
 CellChangeTimes->{3.551454119039116*^9, 3.551454592326049*^9, 
  3.551461065198674*^9, 3.5514613455379887`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"AW\[UDoubleDot]rfel", " ", ":=", "0.08"}]], "Input",
 CellChangeTimes->{{3.5514325335520687`*^9, 3.551432544539563*^9}}],

Cell[BoxData[
 RowBox[{"MW\[UDoubleDot]rfel", " ", ":=", "0.477"}]], "Input",
 CellChangeTimes->{{3.551432796318144*^9, 3.55143280692377*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JW\[UDoubleDot]rfel", " ", "=", 
  RowBox[{
   FractionBox["1", "6"], "MW\[UDoubleDot]rfel", "*", 
   RowBox[{"AW\[UDoubleDot]rfel", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.551432549857912*^9, 3.551432550478158*^9}, {
   3.551432708878772*^9, 3.5514327225826807`*^9}, {3.551432810428279*^9, 
   3.5514328165322523`*^9}, 3.5514541674566927`*^9}],

Cell[BoxData["0.0005087999999999999`"], "Output",
 CellChangeTimes->{3.5514545924380207`*^9, 3.551461345666946*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJW\[UDoubleDot]rfel", "=", 
  RowBox[{
   FractionBox["1", "6"], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"sigmaM", "*", 
        RowBox[{"AW\[UDoubleDot]rfel", "^", "2"}]}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
       "MW\[UDoubleDot]rfel", "*", "AW\[UDoubleDot]rfel", "*", "sigmaD"}], 
       ")"}], "^", "2"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.5514541609639683`*^9, 3.551454197928701*^9}}],

Cell[BoxData["6.708256935382776`*^-6"], "Output",
 CellChangeTimes->{3.5514541990228767`*^9, 3.551454592503791*^9, 
  3.551461345723503*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"LStab", " ", ":=", " ", "0.50"}]], "Input",
 CellChangeTimes->{{3.551432840936811*^9, 3.5514328560740213`*^9}}],

Cell[BoxData[
 RowBox[{"dStab", " ", ":=", "0.08"}]], "Input",
 CellChangeTimes->{{3.551432858604006*^9, 3.551432860335065*^9}, {
  3.551432957519782*^9, 3.551432958631617*^9}}],

Cell[BoxData[
 RowBox[{"MStab", " ", ":=", "0.103"}]], "Input",
 CellChangeTimes->{{3.551432982175831*^9, 3.5514329877668962`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JStab1", " ", "=", " ", 
  RowBox[{
   FractionBox["1", "12"], "MStab", "*", 
   RowBox[{"LStab", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.5514329623639183`*^9, 3.551433000583303*^9}}],

Cell[BoxData["0.002145833333333333`"], "Output",
 CellChangeTimes->{3.5514330018664713`*^9, 3.55143389381658*^9, 
  3.5514545926381197`*^9, 3.551461345849318*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJStab1", "=", 
  RowBox[{
   FractionBox["1", "12"], 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"sigmaM", "*", 
        RowBox[{"LStab", "^", "2"}]}], ")"}], "^", "2"}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"MStab", "*", "LStab", "*", "sigmaD"}], ")"}], "^", "2"}]}], 
    "]"}]}]}]], "Input",
 CellChangeTimes->{{3.551454211109586*^9, 3.551454238391313*^9}}],

Cell[BoxData["0.000041887104386539886`"], "Output",
 CellChangeTimes->{3.551454239271579*^9, 3.551454592688654*^9, 
  3.551461345906823*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JStab2", " ", "=", " ", 
  RowBox[{"JStab1", " ", "+", " ", 
   RowBox[{"MStab", "*", 
    RowBox[{"dStab", "^", "2"}]}]}]}]], "Input",
 CellChangeTimes->{{3.551433004655817*^9, 3.551433015838483*^9}}],

Cell[BoxData["0.002805033333333333`"], "Output",
 CellChangeTimes->{3.551433016876935*^9, 3.551433893871002*^9, 
  3.551454592737322*^9, 3.5514613459513483`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJStab2", " ", "=", " ", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", "sJStab1", ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"sigmaM", "*", 
       RowBox[{"dStab", "^", "2"}]}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"MStab", "*", "dStab", "*", "sigmaD"}], ")"}], "^", "2"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.551454247208843*^9, 3.551454304421196*^9}}],

Cell[BoxData["0.00004456755674129881`"], "Output",
 CellChangeTimes->{3.55145430532555*^9, 3.551454592789439*^9, 
  3.551461346006523*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    FractionBox["1.56", 
     RowBox[{"2", "\[Pi]"}]], ")"}], "^", "2"}], "*", 
  FractionBox[
   RowBox[{"2", "\[Pi]"}], "29494"]}]], "Input",
 CellChangeTimes->{{3.551460266893565*^9, 3.551460300033049*^9}}],

Cell[BoxData["0.000013132144487300348`"], "Output",
 CellChangeTimes->{{3.551460268807438*^9, 3.5514603009368362`*^9}, 
   3.551461346056052*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1269, 662},
WindowMargins->{{Automatic, -631}, {39, Automatic}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 93, 1, 46, "Subtitle"],
Cell[675, 25, 262, 6, 27, "Input"],
Cell[940, 33, 130, 2, 27, "Input"],
Cell[1073, 37, 280, 4, 27, "Input"],
Cell[1356, 43, 229, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[1610, 51, 340, 9, 47, "Input"],
Cell[1953, 62, 289, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2279, 71, 341, 10, 47, "Input"],
Cell[2623, 83, 164, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2824, 90, 799, 23, 47, "Input"],
Cell[3626, 115, 314, 5, 27, "Output"]
}, Open  ]],
Cell[3955, 123, 192, 3, 43, "Input"],
Cell[4150, 128, 216, 5, 27, "Input"],
Cell[4369, 135, 133, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[4527, 141, 262, 7, 46, "Input"],
Cell[4792, 150, 187, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5016, 157, 663, 20, 46, "Input"],
Cell[5682, 179, 143, 2, 30, "Output"]
}, Open  ]],
Cell[5840, 184, 137, 2, 27, "Input"],
Cell[5980, 188, 131, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[6136, 194, 271, 7, 46, "Input"],
Cell[6410, 203, 184, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6631, 210, 605, 19, 46, "Input"],
Cell[7239, 231, 166, 2, 27, "Output"]
}, Open  ]],
Cell[7420, 236, 139, 2, 27, "Input"],
Cell[7562, 240, 194, 3, 27, "Input"],
Cell[7759, 245, 191, 3, 27, "Input"],
Cell[CellGroupData[{
Cell[7975, 252, 514, 14, 46, "Input"],
Cell[8492, 268, 233, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8762, 277, 1057, 32, 62, "Input"],
Cell[9822, 311, 189, 3, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10048, 319, 151, 2, 27, "Input"],
Cell[10202, 323, 174, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10413, 330, 150, 2, 27, "Input"],
Cell[10566, 334, 144, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10747, 341, 132, 2, 27, "Input"],
Cell[10882, 345, 144, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11063, 352, 600, 13, 47, "Input"],
Cell[11666, 367, 261, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11964, 375, 1032, 29, 47, "Input"],
Cell[12999, 406, 163, 2, 27, "Output"]
}, Open  ]],
Cell[13177, 411, 144, 2, 27, "Input"],
Cell[13324, 415, 142, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[13491, 421, 376, 7, 47, "Input"],
Cell[13870, 430, 115, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14022, 436, 514, 15, 47, "Input"],
Cell[14539, 453, 140, 2, 30, "Output"]
}, Open  ]],
Cell[14694, 458, 135, 2, 27, "Input"],
Cell[14832, 462, 177, 3, 27, "Input"],
Cell[15012, 467, 131, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[15168, 473, 215, 5, 46, "Input"],
Cell[15386, 480, 162, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15585, 487, 447, 14, 46, "Input"],
Cell[16035, 503, 140, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16212, 510, 225, 5, 27, "Input"],
Cell[16440, 517, 161, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16638, 524, 473, 14, 27, "Input"],
Cell[17114, 540, 138, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17289, 547, 261, 8, 47, "Input"],
Cell[17553, 557, 145, 2, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
