(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    107406,       2258]
NotebookOptionsPosition[    101139,       2037]
NotebookOutlinePosition[    101549,       2055]
CellTagsIndexPosition[    101506,       2052]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Messwerte f\[UDoubleDot]r Geometrie", "Subsubtitle",
 CellChangeTimes->{{3.551330027687928*^9, 3.551330037900732*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"l1", " ", "=", " ", 
  RowBox[{
  "0.097", "+", "0.043", "+", "0.142", "+", "0.116", "+", "0.028", "+", 
   "0.0735"}]}], "\[IndentingNewLine]", 
 RowBox[{"sl1", " ", "=", 
  RowBox[{
  "0.0005", "+", "0.0005", "+", "0.002", "+", "0.002", "+", "0.0005", "+", 
   "0.0005"}]}], "\[IndentingNewLine]", 
 RowBox[{"l2", " ", "=", 
  RowBox[{"0.083", "+", "0.043", "+", "0.142"}]}], "\[IndentingNewLine]", 
 RowBox[{"sl2", "=", 
  RowBox[{"0.0005", "+", "0.0005", "+", "0.002"}]}], "\[IndentingNewLine]", 
 RowBox[{"l3", " ", ":=", "0.043"}], "\[IndentingNewLine]", 
 RowBox[{"sl3", " ", ":=", "0.005"}], "\[IndentingNewLine]", 
 RowBox[{"l4", " ", ":=", "0.142"}], "\[IndentingNewLine]", 
 RowBox[{"sl4", ":=", "0.002"}], "\[IndentingNewLine]", 
 RowBox[{"l5", " ", ":=", "0.116"}], "\[IndentingNewLine]", 
 RowBox[{"sl5", ":=", "0.002"}], "\[IndentingNewLine]", 
 RowBox[{"l6", " ", ":=", "0.028"}], "\[IndentingNewLine]", 
 RowBox[{"sl6", " ", ":=", "0.0005"}], "\[IndentingNewLine]", 
 RowBox[{"l7", " ", "=", 
  RowBox[{"l5", "+", "l6", "+", "0.0735"}]}], "\[IndentingNewLine]", 
 RowBox[{"sl7", "=", 
  RowBox[{"sl5", "+", "sl6", "+", "0.0005"}]}]}], "Input",
 CellChangeTimes->{{3.551030549063285*^9, 3.551030570247388*^9}, {
  3.551030608768717*^9, 3.551030626990322*^9}, {3.5510307031145983`*^9, 
  3.551030787681451*^9}, {3.551031494688499*^9, 3.551031495230412*^9}, {
  3.551031685697348*^9, 3.5510316857531443`*^9}, {3.551031740553451*^9, 
  3.5510317406388407`*^9}, {3.551031978346829*^9, 3.5510320049685373`*^9}, {
  3.551032266273226*^9, 3.5510322745368357`*^9}, {3.5513359924774647`*^9, 
  3.5513359933767033`*^9}, {3.551529663327745*^9, 3.551529758922155*^9}, {
  3.551529794026845*^9, 3.551529832175931*^9}, {3.551530734488893*^9, 
  3.551530985423575*^9}, {3.5515327373593473`*^9, 3.5515327398218184`*^9}, {
  3.551538804791999*^9, 3.55153880571107*^9}}],

Cell[BoxData["0.49950000000000006`"], "Output",
 CellChangeTimes->{
  3.551532740788845*^9, 3.551533049229108*^9, 3.551538807018895*^9, 
   3.551538902039233*^9, {3.551538963495359*^9, 3.551538974787424*^9}, 
   3.551539106507409*^9, 3.55153919960394*^9, {3.551539251708663*^9, 
   3.5515392741289253`*^9}, 3.551539318616095*^9, 3.551539643093347*^9, 
   3.5515400206151123`*^9, 3.551540093321217*^9, 3.551540225052759*^9, 
   3.551540286649354*^9, {3.5515404302333603`*^9, 3.551540432240485*^9}, 
   3.5515407239397287`*^9, 3.551540825485499*^9, 3.551542601032528*^9, 
   3.551542639222769*^9, 3.551542717224039*^9, 3.551544252067279*^9, {
   3.551544298893762*^9, 3.551544313864464*^9}, 3.5515453446784573`*^9, {
   3.551545954338965*^9, 3.551545972306115*^9}, {3.551546518958467*^9, 
   3.5515465276642113`*^9}, 3.5515465620964203`*^9, 3.551546602645019*^9, 
   3.5517178708136873`*^9, 3.551718251895405*^9, 3.551718411877138*^9, 
   3.551718449933277*^9, 3.551718658870963*^9, 3.5517187251397333`*^9, 
   3.5517187804510603`*^9, 3.551718930921194*^9, 3.551718987529563*^9, 
   3.551719249960541*^9, 3.55171937680329*^9}],

Cell[BoxData["0.006`"], "Output",
 CellChangeTimes->{
  3.551532740788845*^9, 3.551533049229108*^9, 3.551538807018895*^9, 
   3.551538902039233*^9, {3.551538963495359*^9, 3.551538974787424*^9}, 
   3.551539106507409*^9, 3.55153919960394*^9, {3.551539251708663*^9, 
   3.5515392741289253`*^9}, 3.551539318616095*^9, 3.551539643093347*^9, 
   3.5515400206151123`*^9, 3.551540093321217*^9, 3.551540225052759*^9, 
   3.551540286649354*^9, {3.5515404302333603`*^9, 3.551540432240485*^9}, 
   3.5515407239397287`*^9, 3.551540825485499*^9, 3.551542601032528*^9, 
   3.551542639222769*^9, 3.551542717224039*^9, 3.551544252067279*^9, {
   3.551544298893762*^9, 3.551544313864464*^9}, 3.5515453446784573`*^9, {
   3.551545954338965*^9, 3.551545972306115*^9}, {3.551546518958467*^9, 
   3.5515465276642113`*^9}, 3.5515465620964203`*^9, 3.551546602645019*^9, 
   3.5517178708136873`*^9, 3.551718251895405*^9, 3.551718411877138*^9, 
   3.551718449933277*^9, 3.551718658870963*^9, 3.5517187251397333`*^9, 
   3.5517187804510603`*^9, 3.551718930921194*^9, 3.551718987529563*^9, 
   3.551719249960541*^9, 3.551719376806265*^9}],

Cell[BoxData["0.268`"], "Output",
 CellChangeTimes->{
  3.551532740788845*^9, 3.551533049229108*^9, 3.551538807018895*^9, 
   3.551538902039233*^9, {3.551538963495359*^9, 3.551538974787424*^9}, 
   3.551539106507409*^9, 3.55153919960394*^9, {3.551539251708663*^9, 
   3.5515392741289253`*^9}, 3.551539318616095*^9, 3.551539643093347*^9, 
   3.5515400206151123`*^9, 3.551540093321217*^9, 3.551540225052759*^9, 
   3.551540286649354*^9, {3.5515404302333603`*^9, 3.551540432240485*^9}, 
   3.5515407239397287`*^9, 3.551540825485499*^9, 3.551542601032528*^9, 
   3.551542639222769*^9, 3.551542717224039*^9, 3.551544252067279*^9, {
   3.551544298893762*^9, 3.551544313864464*^9}, 3.5515453446784573`*^9, {
   3.551545954338965*^9, 3.551545972306115*^9}, {3.551546518958467*^9, 
   3.5515465276642113`*^9}, 3.5515465620964203`*^9, 3.551546602645019*^9, 
   3.5517178708136873`*^9, 3.551718251895405*^9, 3.551718411877138*^9, 
   3.551718449933277*^9, 3.551718658870963*^9, 3.5517187251397333`*^9, 
   3.5517187804510603`*^9, 3.551718930921194*^9, 3.551718987529563*^9, 
   3.551719249960541*^9, 3.551719376808394*^9}],

Cell[BoxData["0.003`"], "Output",
 CellChangeTimes->{
  3.551532740788845*^9, 3.551533049229108*^9, 3.551538807018895*^9, 
   3.551538902039233*^9, {3.551538963495359*^9, 3.551538974787424*^9}, 
   3.551539106507409*^9, 3.55153919960394*^9, {3.551539251708663*^9, 
   3.5515392741289253`*^9}, 3.551539318616095*^9, 3.551539643093347*^9, 
   3.5515400206151123`*^9, 3.551540093321217*^9, 3.551540225052759*^9, 
   3.551540286649354*^9, {3.5515404302333603`*^9, 3.551540432240485*^9}, 
   3.5515407239397287`*^9, 3.551540825485499*^9, 3.551542601032528*^9, 
   3.551542639222769*^9, 3.551542717224039*^9, 3.551544252067279*^9, {
   3.551544298893762*^9, 3.551544313864464*^9}, 3.5515453446784573`*^9, {
   3.551545954338965*^9, 3.551545972306115*^9}, {3.551546518958467*^9, 
   3.5515465276642113`*^9}, 3.5515465620964203`*^9, 3.551546602645019*^9, 
   3.5517178708136873`*^9, 3.551718251895405*^9, 3.551718411877138*^9, 
   3.551718449933277*^9, 3.551718658870963*^9, 3.5517187251397333`*^9, 
   3.5517187804510603`*^9, 3.551718930921194*^9, 3.551718987529563*^9, 
   3.551719249960541*^9, 3.5517193768105297`*^9}],

Cell[BoxData["0.21750000000000003`"], "Output",
 CellChangeTimes->{
  3.551532740788845*^9, 3.551533049229108*^9, 3.551538807018895*^9, 
   3.551538902039233*^9, {3.551538963495359*^9, 3.551538974787424*^9}, 
   3.551539106507409*^9, 3.55153919960394*^9, {3.551539251708663*^9, 
   3.5515392741289253`*^9}, 3.551539318616095*^9, 3.551539643093347*^9, 
   3.5515400206151123`*^9, 3.551540093321217*^9, 3.551540225052759*^9, 
   3.551540286649354*^9, {3.5515404302333603`*^9, 3.551540432240485*^9}, 
   3.5515407239397287`*^9, 3.551540825485499*^9, 3.551542601032528*^9, 
   3.551542639222769*^9, 3.551542717224039*^9, 3.551544252067279*^9, {
   3.551544298893762*^9, 3.551544313864464*^9}, 3.5515453446784573`*^9, {
   3.551545954338965*^9, 3.551545972306115*^9}, {3.551546518958467*^9, 
   3.5515465276642113`*^9}, 3.5515465620964203`*^9, 3.551546602645019*^9, 
   3.5517178708136873`*^9, 3.551718251895405*^9, 3.551718411877138*^9, 
   3.551718449933277*^9, 3.551718658870963*^9, 3.5517187251397333`*^9, 
   3.5517187804510603`*^9, 3.551718930921194*^9, 3.551718987529563*^9, 
   3.551719249960541*^9, 3.551719376812653*^9}],

Cell[BoxData["0.003`"], "Output",
 CellChangeTimes->{
  3.551532740788845*^9, 3.551533049229108*^9, 3.551538807018895*^9, 
   3.551538902039233*^9, {3.551538963495359*^9, 3.551538974787424*^9}, 
   3.551539106507409*^9, 3.55153919960394*^9, {3.551539251708663*^9, 
   3.5515392741289253`*^9}, 3.551539318616095*^9, 3.551539643093347*^9, 
   3.5515400206151123`*^9, 3.551540093321217*^9, 3.551540225052759*^9, 
   3.551540286649354*^9, {3.5515404302333603`*^9, 3.551540432240485*^9}, 
   3.5515407239397287`*^9, 3.551540825485499*^9, 3.551542601032528*^9, 
   3.551542639222769*^9, 3.551542717224039*^9, 3.551544252067279*^9, {
   3.551544298893762*^9, 3.551544313864464*^9}, 3.5515453446784573`*^9, {
   3.551545954338965*^9, 3.551545972306115*^9}, {3.551546518958467*^9, 
   3.5515465276642113`*^9}, 3.5515465620964203`*^9, 3.551546602645019*^9, 
   3.5517178708136873`*^9, 3.551718251895405*^9, 3.551718411877138*^9, 
   3.551718449933277*^9, 3.551718658870963*^9, 3.5517187251397333`*^9, 
   3.5517187804510603`*^9, 3.551718930921194*^9, 3.551718987529563*^9, 
   3.551719249960541*^9, 3.55171937681474*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"r1", ":=", "0.03"}], "\[IndentingNewLine]", 
 RowBox[{"sr1", ":=", "0.00025"}], "\[IndentingNewLine]", 
 RowBox[{"r2", ":=", "0.1225"}], "\[IndentingNewLine]", 
 RowBox[{"sr2", ":=", "0.002"}], "\[IndentingNewLine]", 
 RowBox[{"r3", ":=", "0.004725"}], "\[IndentingNewLine]", 
 RowBox[{"sr3", ":=", "0.0005"}]}], "Input",
 CellChangeTimes->{{3.551030790661563*^9, 3.551030806200951*^9}, {
   3.55103086732962*^9, 3.551030911398374*^9}, {3.551031433922805*^9, 
   3.5510314357121267`*^9}, {3.55103162527217*^9, 3.55103163863441*^9}, {
   3.5510320098642597`*^9, 3.5510320202640867`*^9}, {3.5510322774972773`*^9, 
   3.551032281368433*^9}, {3.551529148788148*^9, 3.5515291518919363`*^9}, {
   3.551531073141829*^9, 3.551531135211029*^9}, {3.5515402184552383`*^9, 
   3.5515402205178957`*^9}, 3.5515402848688507`*^9, {3.551540427874958*^9, 
   3.551540427936164*^9}, {3.551544435975615*^9, 3.551544436207562*^9}}],

Cell[BoxData[{
 RowBox[{"m1", ":=", "1.324"}], "\[IndentingNewLine]", 
 RowBox[{"sm1", ":=", "0.002"}], "\[IndentingNewLine]", 
 RowBox[{"m2", ":=", 
  RowBox[{"0.1532", "*", 
   RowBox[{"l1", "/", "0.248"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"sm2", ":=", "0.002"}], "\[IndentingNewLine]", 
 RowBox[{"m3", ":=", "0.936"}], "\[IndentingNewLine]", 
 RowBox[{"sm3", ":=", "0.0005"}], "\[IndentingNewLine]", 
 RowBox[{"m4", " ", ":=", "0.100"}], "\[IndentingNewLine]", 
 RowBox[{"sm4", " ", ":=", " ", "0.0005"}]}], "Input",
 CellChangeTimes->{{3.551030914300335*^9, 3.551030956476789*^9}, {
  3.551032024847755*^9, 3.551032033911645*^9}, {3.551032250274892*^9, 
  3.5510322569132433`*^9}, {3.551330431659396*^9, 3.551330460178594*^9}, {
  3.5513305339767027`*^9, 3.551330537176539*^9}, {3.551529126342743*^9, 
  3.55152912915593*^9}, {3.551531162970356*^9, 3.5515311859848337`*^9}, {
  3.55153895420304*^9, 3.551538960681847*^9}, {3.5515396354240847`*^9, 
  3.5515396407750397`*^9}, {3.551540208536825*^9, 3.5515402118798447`*^9}, {
  3.551544222513674*^9, 3.5515442498686333`*^9}, {3.55154429180412*^9, 
  3.5515442939798183`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messwerte f\[UDoubleDot]r Pendelschwingung", "Subsubtitle",
 CellChangeTimes->{{3.55132999629443*^9, 3.55133000718157*^9}}],

Cell[BoxData[{
 RowBox[{"TP1", " ", ":=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"18.74", "+", "18.81"}], ")"}], "*", 
   "0.5"}]}], "\[IndentingNewLine]", 
 RowBox[{"TP2", " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"19", "+", "18.51"}], ")"}], "*", 
   "0.5"}]}], "\[IndentingNewLine]", 
 RowBox[{"TP3", " ", ":=", " ", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"18.76", "+", "18.74"}], ")"}], "*", 
   "0.5"}]}], "\[IndentingNewLine]", 
 RowBox[{"sTP", ":=", " ", "0.5"}]}], "Input",
 CellChangeTimes->{{3.551330047074767*^9, 3.5513300499893503`*^9}, {
   3.551330196762063*^9, 3.5513302124498653`*^9}, 3.551330244009101*^9, {
   3.551330494385735*^9, 3.551330495801402*^9}, {3.551330549416025*^9, 
   3.5513306266618032`*^9}, {3.551336637679892*^9, 3.551336640582193*^9}, {
   3.551340516217218*^9, 3.551340518703444*^9}, {3.5515289569307413`*^9, 
   3.5515289841369247`*^9}}],

Cell[BoxData[
 RowBox[{"g", ":=", " ", "9.81"}]], "Input",
 CellChangeTimes->{{3.551330363902195*^9, 3.551330365893074*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messwerte f\[UDoubleDot]r die Pr\[ADoubleDot]zession", "Subsubtitle",
 CellChangeTimes->{{3.551330643547677*^9, 3.551330659850753*^9}}],

Cell[BoxData[{
 RowBox[{"mP1", " ", ":=", "0.060"}], "\[IndentingNewLine]", 
 RowBox[{"mP2", ":=", "0.080"}], "\[IndentingNewLine]", 
 RowBox[{"mP3", ":=", "0.100"}], "\[IndentingNewLine]", 
 RowBox[{"smP", ":=", "0.0005"}], "\[IndentingNewLine]", 
 RowBox[{"mu1", " ", ":=", "14.1003"}], "\[IndentingNewLine]", 
 RowBox[{"smu1", " ", ":=", "0.3976"}], "\[IndentingNewLine]", 
 RowBox[{"mu2", " ", ":=", "20.5209"}], "\[IndentingNewLine]", 
 RowBox[{"smu2", " ", ":=", "1.617"}], "\[IndentingNewLine]", 
 RowBox[{"mu3", ":=", "26.1883"}], "\[IndentingNewLine]", 
 RowBox[{"smu3", ":=", "0.7799"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdyE0og3EAx/GHso2DiT0pF6Q4zFBrDuzgcVKrKVtrNIohUlutbWwO85KS
5sAuU1qMhdxkybZMed0UubAdeIpoPSEWapF5fv/Dt099K/vMHQO5FEWV8UFa
vF27YuMYh/68Dkpafyxwd8Q7Bg+6VapV3k/FGVGQlmvgW1VKBycUxl7YsPU0
DBOsyQyHqhcssNghuPDzFoZcxICSuYbTwiXiw2jwFr7msCmYbukvX+Nl2sJE
98ypFM6zMhkM1MsV8DkSJU7t001wPVNBVEVCUcrOMcpf+hg6H/NiMCQeJ0oy
7yw0aIs42PX9EhbwNg7eReBH7CQGnfdfcWi68geEvNad5Ca8sWqCsOBwbg8a
j5iMiLfHnszCUumfKp/X1tyuhikfp4eXbroT+ko2FqHBlfDAuEfkJX+2hqid
TC9DtS5L/AcMP9RK
  "]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Messwerte f\[UDoubleDot]r die Nutation", "Subsubtitle",
 CellChangeTimes->{{3.551331452430396*^9, 3.551331462203339*^9}, {
  3.551333445360753*^9, 3.551333447064417*^9}}],

Cell[BoxData[{
 RowBox[{"dNut", " ", ":=", " ", "0.06"}], "\[IndentingNewLine]", 
 RowBox[{"sdNut", " ", ":=", " ", "0.06"}], "\[IndentingNewLine]", 
 RowBox[{"K2", " ", ":=", "0.155104"}], "\[IndentingNewLine]", 
 RowBox[{"sK2", ":=", "0.002912"}]}], "Input",
 CellChangeTimes->{{3.5513314658905478`*^9, 3.551331493716485*^9}, {
   3.5513334221635323`*^9, 3.5513334416914587`*^9}, {3.551531317573944*^9, 
   3.5515313176225348`*^9}, {3.551531373365333*^9, 3.551531380938672*^9}, {
   3.551539265447936*^9, 3.551539272121582*^9}, {3.551539310126645*^9, 
   3.55153931595848*^9}, {3.551718249969178*^9, 3.551718250855323*^9}, {
   3.551718986236827*^9, 3.5517189868984747`*^9}, 3.551719248257573*^9, {
   3.551719369799617*^9, 3.5517193753668737`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TPendel", " ", "=", " ", 
  FractionBox[
   RowBox[{"TP1", " ", "+", " ", "TP2", " ", "+", " ", "TP3"}], 
   "30"]}]], "Input",
 CellChangeTimes->{{3.551329881706421*^9, 3.551329903642645*^9}, {
   3.5513301716131973`*^9, 3.551330175779027*^9}, 3.551330219290969*^9}],

Cell[BoxData["1.8760000000000001`"], "Output",
 CellChangeTimes->{{3.551330219743638*^9, 3.551330246015101*^9}, 
   3.551330358553809*^9, {3.551330539628729*^9, 3.551330628079516*^9}, 
   3.551331661217725*^9, 3.551331868227517*^9, 3.5513319420015097`*^9, 
   3.551331979081457*^9, 3.551332963505995*^9, 3.551333027415182*^9, {
   3.5513331350299053`*^9, 3.551333150423238*^9}, {3.5513331848605623`*^9, 
   3.551333201879581*^9}, {3.551333245184877*^9, 3.5513332717857533`*^9}, 
   3.55133333365447*^9, 3.551335561633337*^9, 3.551336002428563*^9, 
   3.551336044140768*^9, 3.551336078611801*^9, {3.551336129421232*^9, 
   3.5513362022495193`*^9}, {3.551336238993752*^9, 3.551336263934799*^9}, 
   3.5513363526197767`*^9, 3.551336641971888*^9, 3.5513367032260103`*^9, 
   3.5513368107410727`*^9, 3.5513368416754503`*^9, {3.5513368794194393`*^9, 
   3.551336914404655*^9}, 3.551340523398402*^9, 3.5513427241124067`*^9, {
   3.5513430162645397`*^9, 3.551343062509646*^9}, 3.551343114514743*^9, 
   3.55152848267822*^9, 3.5515285256692343`*^9, {3.551528774288805*^9, 
   3.5515287885020123`*^9}, 3.551528988803618*^9, 3.551529060586569*^9, 
   3.551529155480661*^9, 3.5515291982859077`*^9, 3.55152976842839*^9, 
   3.551531142818984*^9, 3.551531189993857*^9, 3.5515313211719723`*^9, 
   3.551531383091604*^9, 3.5515330494930677`*^9, 3.551538902445093*^9, {
   3.551538963824849*^9, 3.5515389750845957`*^9}, 3.5515391068412933`*^9, 
   3.55153919987883*^9, {3.551539252015436*^9, 3.5515392743839703`*^9}, 
   3.5515393188813753`*^9, 3.551539643336458*^9, 3.551540020891263*^9, 
   3.551540093602672*^9, 3.551540225310233*^9, 3.5515402868807993`*^9, {
   3.5515404305278053`*^9, 3.551540432545803*^9}, 3.5515407242621098`*^9, 
   3.5515408257530413`*^9, 3.551542601332062*^9, 3.55154263947191*^9, 
   3.551542717496385*^9, 3.551544252360744*^9, {3.551544299169918*^9, 
   3.551544314131113*^9}, 3.5515453449777927`*^9, {3.551545954600564*^9, 
   3.55154597259904*^9}, {3.551546519271824*^9, 3.5515465279409723`*^9}, 
   3.5515465623945227`*^9, 3.551546602926361*^9, 3.551717871130857*^9, 
   3.551718252189784*^9, 3.551718412125134*^9, 3.551718450200157*^9, 
   3.551718659218964*^9, 3.551718725438074*^9, 3.551718780781884*^9, 
   3.5517189311866617`*^9, 3.55171898782362*^9, 3.5517192502433558`*^9, 
   3.55171937705252*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sTPendel", " ", "=", 
   FractionBox["sTP", 
    RowBox[{"10", "*", 
     RowBox[{"Sqrt", "[", "3", "]"}]}]]}], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.551329819002117*^9, 3.551329823092119*^9}, {
   3.551329862904099*^9, 3.551329868501514*^9}, {3.551329926657216*^9, 
   3.5513299854238987`*^9}, {3.551330184720324*^9, 3.5513301902825537`*^9}, 
   3.551330221753625*^9}],

Cell[BoxData["0.028867513459481294`"], "Output",
 CellChangeTimes->{{3.551330224493023*^9, 3.5513302476241207`*^9}, 
   3.55133035860919*^9, {3.5513305396687326`*^9, 3.551330628120432*^9}, 
   3.551331661263172*^9, 3.55133186827245*^9, 3.551331942046584*^9, 
   3.551331979165436*^9, 3.551332963545862*^9, 3.551333027451583*^9, {
   3.551333135065661*^9, 3.551333150458853*^9}, {3.55133318489669*^9, 
   3.5513332019174643`*^9}, {3.551333245222146*^9, 3.551333271821289*^9}, 
   3.5513333337126713`*^9, 3.551335561718544*^9, 3.551336002470437*^9, 
   3.551336044177659*^9, 3.551336078647828*^9, {3.551336129457395*^9, 
   3.5513362022849216`*^9}, {3.551336239030966*^9, 3.551336263970996*^9}, 
   3.551336352659808*^9, 3.551336642007682*^9, 3.551336703265074*^9, 
   3.551336810777375*^9, 3.5513368417120857`*^9, {3.55133687945463*^9, 
   3.551336914440072*^9}, 3.551340523433936*^9, 3.551342724182273*^9, {
   3.551343016305533*^9, 3.55134306257592*^9}, 3.5513431145545597`*^9, 
   3.551528482713553*^9, 3.55152852570191*^9, {3.551528774322797*^9, 
   3.551528788537483*^9}, 3.5515289888367987`*^9, 3.551529060667817*^9, 
   3.55152915551722*^9, 3.5515291983389473`*^9, 3.5515297684751797`*^9, 
   3.5515311428580637`*^9, 3.551531190034658*^9, 3.551531321228866*^9, 
   3.551531383146476*^9, 3.551533049529454*^9, 3.551538902513048*^9, {
   3.551538963883803*^9, 3.5515389751729813`*^9}, 3.55153910690102*^9, 
   3.551539199939473*^9, {3.5515392520759993`*^9, 3.551539274448225*^9}, 
   3.5515393189204817`*^9, 3.551539643374564*^9, 3.5515400209314337`*^9, 
   3.551540093663582*^9, 3.551540225351141*^9, 3.551540286947506*^9, {
   3.5515404305648127`*^9, 3.551540432607815*^9}, 3.551540724301175*^9, 
   3.5515408258060083`*^9, 3.551542601370379*^9, 3.5515426395282583`*^9, 
   3.551542717534779*^9, 3.551544252399832*^9, {3.5515442992105627`*^9, 
   3.551544314189217*^9}, 3.55154534501434*^9, {3.551545954635481*^9, 
   3.5515459726356707`*^9}, {3.551546519309141*^9, 3.551546527975061*^9}, 
   3.551546562431583*^9, 3.5515466029624557`*^9, 3.5517178711857367`*^9, 
   3.551718252223364*^9, 3.5517184121785097`*^9, 3.551718450239929*^9, 
   3.551718659258482*^9, 3.551718725477131*^9, 3.551718780832917*^9, 
   3.5517189312265368`*^9, 3.55171898785806*^9, 3.551719250279798*^9, 
   3.55171937708636*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JFT", " ", "=", " ", 
  RowBox[{
   FractionBox["1", "2"], "m1", "*", 
   RowBox[{"r2", "^", "2"}]}]}]], "Input",
 CellChangeTimes->{{3.551287119971347*^9, 3.551287140626979*^9}, {
   3.551287259656777*^9, 3.551287259823765*^9}, 3.5513363303357487`*^9}],

Cell[BoxData["0.009934137499999999`"], "Output",
 CellChangeTimes->{
  3.5512871411785603`*^9, {3.551287266228689*^9, 3.5512872693474073`*^9}, 
   3.5512874460873947`*^9, 3.551330358660491*^9, {3.5513305397470016`*^9, 
   3.5513306281680098`*^9}, 3.55133166132625*^9, 3.5513318683357363`*^9, 
   3.551331942093317*^9, 3.5513319792042837`*^9, 3.5513329635914707`*^9, 
   3.551333027485066*^9, {3.551333135102778*^9, 3.5513331504912367`*^9}, {
   3.5513331849303226`*^9, 3.551333201950157*^9}, {3.551333245253766*^9, 
   3.551333271867877*^9}, 3.551333333757707*^9, 3.551335561762712*^9, 
   3.551336002516301*^9, 3.5513360442087812`*^9, 3.5513360786797667`*^9, {
   3.5513361294899817`*^9, 3.5513362023174458`*^9}, {3.551336239063802*^9, 
   3.55133626400408*^9}, 3.551336352706456*^9, 3.5513366420416327`*^9, 
   3.551336703296015*^9, 3.551336810811461*^9, 3.55133684174507*^9, {
   3.551336879487619*^9, 3.551336914473854*^9}, 3.5513405234645977`*^9, 
   3.5513427243001423`*^9, {3.55134301635289*^9, 3.551343062627163*^9}, 
   3.551343114601823*^9, 3.5515284827446613`*^9, 3.551528525734761*^9, {
   3.551528774355679*^9, 3.551528788570224*^9}, 3.5515289888692713`*^9, 
   3.5515290607245913`*^9, 3.551529155547174*^9, 3.5515291983884907`*^9, 
   3.551529768507637*^9, 3.551531142911036*^9, 3.551531190081613*^9, 
   3.551531321277074*^9, 3.551531383195281*^9, 3.551533049562223*^9, 
   3.5515389025783997`*^9, {3.55153896392242*^9, 3.551538975254468*^9}, 
   3.5515391069649563`*^9, 3.551539200020742*^9, {3.5515392521234493`*^9, 
   3.5515392744888277`*^9}, 3.551539318969701*^9, 3.5515396434126053`*^9, 
   3.551540020979437*^9, 3.5515400937250853`*^9, 3.5515402254022503`*^9, 
   3.5515402869862127`*^9, {3.551540430615473*^9, 3.5515404326585493`*^9}, 
   3.5515407243343782`*^9, 3.5515408258836203`*^9, 3.5515426014205217`*^9, 
   3.5515426395807657`*^9, 3.551542717585183*^9, 3.5515442524491043`*^9, {
   3.5515442992603188`*^9, 3.551544314235742*^9}, 3.551545345047812*^9, {
   3.551545954668275*^9, 3.5515459726855*^9}, {3.551546519359497*^9, 
   3.551546528009303*^9}, 3.551546562465171*^9, 3.551546602996149*^9, 
   3.551717871232106*^9, 3.55171825225882*^9, 3.551718412241674*^9, 
   3.5517184502874403`*^9, 3.551718659306242*^9, 3.5517187255238323`*^9, 
   3.551718780887773*^9, 3.551718931273157*^9, 3.551718987892888*^9, 
   3.551719250310376*^9, 3.551719377118374*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJFT", "=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"m1", " ", "r2", " ", "sr2"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        SuperscriptBox["r2", "2"], " ", "sm1"}], "2"], ")"}], 
     "2"]}]]}]], "Input",
 CellChangeTimes->{{3.551287147702183*^9, 3.5512871893948393`*^9}, {
   3.5512872615938053`*^9, 3.5512872638571663`*^9}, 3.551336332808717*^9}],

Cell[BoxData["0.00032472691902437424`"], "Output",
 CellChangeTimes->{
  3.55128718056319*^9, {3.551287264285054*^9, 3.5512872693848553`*^9}, 
   3.551287446128614*^9, 3.551330358710223*^9, {3.551330539801708*^9, 
   3.551330628220742*^9}, 3.551331661375368*^9, 3.551331868383958*^9, 
   3.5513319421430187`*^9, 3.551331979255159*^9, 3.551332963642118*^9, 
   3.55133302751897*^9, {3.5513331351492357`*^9, 3.551333150524806*^9}, {
   3.551333184962322*^9, 3.551333201983987*^9}, {3.551333245287429*^9, 
   3.551333271903837*^9}, 3.551333333808256*^9, 3.551335561813513*^9, 
   3.55133600256649*^9, 3.5513360442591057`*^9, 3.551336078713402*^9, {
   3.551336129523134*^9, 3.55133620235187*^9}, {3.551336239096793*^9, 
   3.551336264036942*^9}, 3.551336352757592*^9, 3.551336642074665*^9, 
   3.551336703326867*^9, 3.551336810843611*^9, 3.55133684177776*^9, {
   3.551336879517544*^9, 3.551336914504883*^9}, 3.5513405235039787`*^9, 
   3.5513427245158367`*^9, {3.551343016402442*^9, 3.5513430626651773`*^9}, 
   3.551343114651826*^9, 3.5515284827774897`*^9, 3.551528525767729*^9, {
   3.551528774396614*^9, 3.551528788602895*^9}, 3.551528988903165*^9, 
   3.551529060769226*^9, 3.551529155580509*^9, 3.551529198439301*^9, 
   3.5515297685408783`*^9, 3.551531142960844*^9, 3.55153119011478*^9, 
   3.551531321326549*^9, 3.5515313832456083`*^9, 3.551533049596641*^9, 
   3.551538902623728*^9, {3.551538963972064*^9, 3.551538975305483*^9}, 
   3.551539107028117*^9, 3.551539200084454*^9, {3.551539252170567*^9, 
   3.551539274551136*^9}, 3.551539319018993*^9, 3.551539643457852*^9, 
   3.551540021030408*^9, 3.5515400937748404`*^9, 3.5515401555568857`*^9, 
   3.5515402254488297`*^9, 3.551540287022648*^9, {3.551540430652961*^9, 
   3.55154043272001*^9}, 3.551540724384584*^9, 3.551540825922372*^9, 
   3.551542601468609*^9, 3.5515426396300488`*^9, 3.5515427176220427`*^9, 
   3.551544252501522*^9, {3.551544299309897*^9, 3.551544314285303*^9}, 
   3.551545345080998*^9, {3.55154595470192*^9, 3.5515459727183123`*^9}, {
   3.55154651939154*^9, 3.551546528059697*^9}, 3.551546562495305*^9, 
   3.551546603045866*^9, 3.551717871286483*^9, 3.551718252290144*^9, 
   3.551718412280426*^9, 3.5517184503344297`*^9, 3.55171865935423*^9, 
   3.5517187255751123`*^9, 3.551718780932391*^9, 3.551718931322826*^9, 
   3.551718987926775*^9, 3.551719250345068*^9, 3.551719377151286*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JScheibe", "=", 
  RowBox[{"m1", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"l5", "+", 
        FractionBox["l6", "2"]}], ")"}], "2"], "+", 
     FractionBox[
      SuperscriptBox["l6", "2"], "12"], "+", 
     FractionBox[
      SuperscriptBox["r2", "2"], "4"]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.551031060919815*^9, 3.551031096428816*^9}, {
  3.551287199459984*^9, 3.5512872044719152`*^9}}],

Cell[BoxData["0.027429170083333336`"], "Output",
 CellChangeTimes->{{3.55103109019431*^9, 3.551031097167576*^9}, 
   3.551031437864746*^9, 3.551031498721004*^9, 3.551031640875122*^9, 
   3.551031687164864*^9, 3.551031743240458*^9, 3.551031842949284*^9, 
   3.551032035315385*^9, 3.5510322437046347`*^9, 3.551032282855487*^9, 
   3.55103277233132*^9, 3.551285084762426*^9, {3.551287011362019*^9, 
   3.551287031653681*^9}, 3.551287067752606*^9, 3.551287269417673*^9, 
   3.551287446211547*^9, 3.55133035875918*^9, {3.551330539835997*^9, 
   3.551330628269661*^9}, 3.551331661426346*^9, 3.5513318684354057`*^9, 
   3.5513319421925898`*^9, 3.551331979304225*^9, 3.551332963678581*^9, 
   3.551333027551999*^9, {3.551333135181856*^9, 3.551333150557619*^9}, {
   3.5513331849962893`*^9, 3.551333202016905*^9}, {3.5513332453201017`*^9, 
   3.551333271937435*^9}, 3.551333333857925*^9, 3.5513355618629704`*^9, 
   3.551336002616349*^9, 3.551336044292778*^9, 3.551336078743993*^9, {
   3.5513361295565643`*^9, 3.551336202382331*^9}, {3.55133623912903*^9, 
   3.551336264070071*^9}, 3.551336352807645*^9, 3.551336642107563*^9, 
   3.551336703362145*^9, 3.5513368108749027`*^9, 3.551336841810919*^9, {
   3.551336879552195*^9, 3.551336914537952*^9}, 3.551340523537744*^9, 
   3.551342724880204*^9, {3.551343016451933*^9, 3.551343062712989*^9}, 
   3.551343114700787*^9, 3.551528482811098*^9, 3.551528525800536*^9, {
   3.5515287744380903`*^9, 3.551528788635296*^9}, 3.551528988935704*^9, 
   3.551529060819336*^9, 3.55152915561369*^9, 3.5515291985031853`*^9, 
   3.551529768574501*^9, 3.5515311430099907`*^9, 3.551531190148493*^9, 
   3.551531321376322*^9, 3.5515313832955*^9, 3.551533049629327*^9, 
   3.5515389026739883`*^9, {3.5515389640558023`*^9, 3.551538975376951*^9}, 
   3.551539107078796*^9, 3.551539200157979*^9, {3.551539252224633*^9, 
   3.551539274585853*^9}, 3.551539319072092*^9, 3.5515396435103416`*^9, 
   3.551540021062646*^9, 3.5515400938288193`*^9, 3.551540225499752*^9, 
   3.551540287068877*^9, {3.5515404306993227`*^9, 3.5515404327751827`*^9}, 
   3.551540724418294*^9, 3.551540825971987*^9, 3.5515426015201473`*^9, 
   3.55154263967838*^9, 3.551542717667679*^9, 3.551544252551559*^9, {
   3.551544299359633*^9, 3.551544314334985*^9}, 3.5515453451143847`*^9, {
   3.5515459547355127`*^9, 3.551545972768783*^9}, {3.551546519442574*^9, 
   3.551546528123015*^9}, 3.551546562535582*^9, 3.55154660309478*^9, 
   3.55171787133412*^9, 3.5517182523252487`*^9, 3.551718412329344*^9, 
   3.551718450386396*^9, 3.55171865940591*^9, 3.55171872562261*^9, 
   3.551718780983016*^9, 3.551718931372004*^9, 3.551718987957468*^9, 
   3.551719250378481*^9, 3.551719377185813*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJScheibe", "=", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"sm1", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"l5", "+", 
             FractionBox["l6", "2"]}], ")"}], "2"], "+", 
          FractionBox[
           SuperscriptBox["l6", "2"], "12"], "+", 
          FractionBox[
           SuperscriptBox["r2", "2"], "4"]}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "m1", " ", "sl5", " ", 
        RowBox[{"(", 
         RowBox[{"l5", "+", 
          FractionBox["l6", "2"]}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m1", " ", "sl6", " ", 
        RowBox[{"(", 
         RowBox[{"l5", "+", 
          FractionBox[
           RowBox[{"2", " ", "l6"}], "3"]}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"m1", " ", "r2", " ", "sr2"}], "2"], ")"}], "2"]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5510320644503317`*^9, 3.5510320963203783`*^9}, {
   3.551032150775365*^9, 3.551032239592195*^9}, 3.551286567170451*^9, 
   3.551286733315063*^9, {3.55128720837184*^9, 3.551287211929522*^9}}],

Cell[BoxData["0.0007141251075446477`"], "Output",
 CellChangeTimes->{{3.551032239985894*^9, 3.551032243738171*^9}, 
   3.551032282891094*^9, 3.551032554146655*^9, 3.55103277236989*^9, 
   3.551285084844244*^9, {3.55128701140278*^9, 3.5512870317085238`*^9}, 
   3.55128706780984*^9, 3.5512872694689903`*^9, 3.551287446257918*^9, 
   3.551330358807911*^9, {3.551330539899398*^9, 3.551330628319281*^9}, 
   3.551331661475314*^9, 3.551331868485051*^9, 3.551331942242095*^9, 
   3.551331979353928*^9, 3.551332963724778*^9, 3.551333027584936*^9, {
   3.551333135233046*^9, 3.551333150607498*^9}, {3.551333185027851*^9, 
   3.551333202050625*^9}, {3.5513332453710623`*^9, 3.5513332719886293`*^9}, 
   3.5513333339065104`*^9, 3.551335561894678*^9, 3.551336002665401*^9, 
   3.551336044342381*^9, 3.551336078781994*^9, {3.551336129607012*^9, 
   3.5513362024175158`*^9}, {3.551336239167205*^9, 3.55133626410303*^9}, 
   3.551336352856165*^9, 3.551336642141678*^9, 3.551336703414196*^9, 
   3.551336810907668*^9, 3.551336841861938*^9, {3.5513368795866613`*^9, 
   3.551336914570992*^9}, 3.551340523584156*^9, 3.55134272503878*^9, {
   3.551343016502616*^9, 3.551343062761936*^9}, 3.551343114751113*^9, 
   3.5515284828484697`*^9, 3.551528525834931*^9, {3.551528774472115*^9, 
   3.551528788667931*^9}, 3.551528988969696*^9, 3.551529060869989*^9, 
   3.551529155646759*^9, 3.5515291985547132`*^9, 3.551529768607999*^9, 
   3.551531143043275*^9, 3.551531190179266*^9, 3.5515313214118843`*^9, 
   3.551531383345419*^9, 3.5515330496624727`*^9, 3.551538902723751*^9, {
   3.55153896409613*^9, 3.551538975449107*^9}, 3.5515391071831293`*^9, 
   3.5515392002217073`*^9, {3.551539252273057*^9, 3.551539274634644*^9}, 
   3.5515393191202583`*^9, 3.5515396435598583`*^9, 3.5515400211121283`*^9, 
   3.551540093877821*^9, 3.551540225535198*^9, 3.5515402871187973`*^9, {
   3.551540430749289*^9, 3.551540432812036*^9}, 3.551540724467452*^9, 
   3.551540826023705*^9, 3.551542601569573*^9, 3.551542639728437*^9, 
   3.551542717717598*^9, 3.551544252601474*^9, {3.551544299409877*^9, 
   3.551544314385619*^9}, 3.551545345163797*^9, {3.551545954768342*^9, 
   3.551545972801197*^9}, {3.551546519491934*^9, 3.551546528158647*^9}, 
   3.551546562568303*^9, 3.551546603145293*^9, 3.551717871382081*^9, 
   3.551718252358013*^9, 3.5517184123763514`*^9, 3.551718450437003*^9, 
   3.551718659455153*^9, 3.5517187256749907`*^9, 3.551718781032751*^9, 
   3.551718931420156*^9, 3.551718987993023*^9, 3.551719250412223*^9, 
   3.551719377221204*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JStange", "=", 
  RowBox[{"m2", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["l1", "2"], "12"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["l1", "2"], "-", "l7"}], ")"}], "2"], "+", 
     FractionBox[
      SuperscriptBox["r3", "2"], "4"]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.551031098907988*^9, 3.551031132314117*^9}, {
  3.551287215583152*^9, 3.5512872205978947`*^9}}],

Cell[BoxData["0.00673817276666545`"], "Output",
 CellChangeTimes->{{3.551718910994825*^9, 3.5517189314722757`*^9}, 
   3.5517189880263557`*^9, 3.551719250462207*^9, 3.5517193772699747`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJStange", "=", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"sm2", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           SuperscriptBox["l1", "2"], "12"], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FractionBox["l1", "2"], "-", "l7"}], ")"}], "2"], "+", 
          FractionBox[
           SuperscriptBox["r3", "2"], "4"]}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m2", " ", "sl1", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"2", " ", "l1"}], "3"], "-", "l7"}], ")"}]}], ")"}], "2"], 
     "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "m2", " ", "sl7", " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox["l1", "2"], "-", "l7"}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"m2", " ", "r3", " ", "sr3"}], "2"], ")"}], "2"]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5512869088232527`*^9, 3.5512869225231953`*^9}, {
  3.551286995370487*^9, 3.5512870050210457`*^9}, {3.551287044190433*^9, 
  3.551287058923772*^9}}],

Cell[BoxData["0.00022626817443089435`"], "Output",
 CellChangeTimes->{
  3.5512869132280197`*^9, {3.551287011528739*^9, 3.551287031806547*^9}, 
   3.551287067940427*^9, 3.5512872695714083`*^9, 3.551287446357586*^9, 
   3.5513303589089727`*^9, {3.55133053999959*^9, 3.5513306284187517`*^9}, 
   3.551331661575122*^9, 3.551331868584844*^9, 3.551331942342277*^9, 
   3.551331979454173*^9, 3.551332963825131*^9, 3.5513330276511374`*^9, {
   3.551333135331608*^9, 3.55133315070753*^9}, {3.551333185128249*^9, 
   3.551333202115984*^9}, {3.551333245470337*^9, 3.551333272086132*^9}, 
   3.551333334007656*^9, 3.55133556196334*^9, 3.55133600276562*^9, 
   3.551336044442402*^9, 3.5513360788796053`*^9, {3.551336129703794*^9, 
   3.551336202483651*^9}, {3.551336239263749*^9, 3.551336264168202*^9}, 
   3.551336352956534*^9, 3.5513366422053537`*^9, 3.551336703511426*^9, 
   3.551336810975094*^9, 3.5513368419597807`*^9, {3.55133687968751*^9, 
   3.551336914637336*^9}, 3.551340523683536*^9, 3.551342725141219*^9, {
   3.551343016601256*^9, 3.551343062862957*^9}, 3.55134311485019*^9, 
   3.551528482944311*^9, 3.551528525901012*^9, {3.551528774555086*^9, 
   3.551528788736217*^9}, 3.551528989052055*^9, 3.5515290609683247`*^9, 
   3.55152915571389*^9, 3.551529198665226*^9, 3.551529768674253*^9, 
   3.551531143109104*^9, 3.551531190245584*^9, 3.551531321525576*^9, 
   3.551531383445024*^9, 3.5515330497288847`*^9, 3.551538902827066*^9, {
   3.551538964226136*^9, 3.551538975571849*^9}, 3.551539107325163*^9, 
   3.55153920035086*^9, {3.5515392523713007`*^9, 3.5515392747359533`*^9}, 
   3.551539319218495*^9, 3.551539643640072*^9, 3.5515400211978703`*^9, 
   3.551540093974215*^9, 3.551540225634056*^9, 3.551540287219564*^9, {
   3.551540430847849*^9, 3.551540432906496*^9}, 3.551540724564989*^9, 
   3.551540826121619*^9, 3.5515426016679583`*^9, 3.551542639827005*^9, 
   3.551542717817833*^9, 3.5515442527010183`*^9, {3.5515442995086403`*^9, 
   3.551544314484518*^9}, 3.551545345247137*^9, {3.5515459548353453`*^9, 
   3.5515459728833323`*^9}, {3.551546519558707*^9, 3.5515465282433558`*^9}, 
   3.551546562663641*^9, 3.551546603228367*^9, 3.551717871532816*^9, 
   3.5517182527227793`*^9, 3.55171841292417*^9, 3.5517184510803137`*^9, 
   3.5517186600711393`*^9, 3.551718726251812*^9, 3.5517187817965*^9, 
   3.5517189315230427`*^9, 3.551718988058025*^9, 3.551719250512204*^9, 
   3.551719377322023*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JGegengewicht", "=", 
  RowBox[{"m3", " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      SuperscriptBox["l3", "2"], "12"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["l3", "2"], "+", "l4"}], ")"}], "2"], "+", 
     FractionBox[
      SuperscriptBox["r1", "2"], "4"]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.551031140795816*^9, 3.551031167465176*^9}, {
  3.551287225697508*^9, 3.5512872291650867`*^9}, {3.551539176607175*^9, 
  3.5515391980778503`*^9}}],

Cell[BoxData["0.025376207999999994`"], "Output",
 CellChangeTimes->{
  3.551031167987059*^9, 3.551031437968451*^9, 3.5510314988355503`*^9, 
   3.5510315822227993`*^9, 3.5510316409775133`*^9, 3.551031687279972*^9, 
   3.5510317433440313`*^9, 3.55103184303601*^9, 3.551032035413514*^9, 
   3.5510322438543158`*^9, 3.5510322829823923`*^9, 3.551032772466548*^9, 
   3.5512850849466133`*^9, {3.551287011595354*^9, 3.5512870318855057`*^9}, 
   3.551287067986343*^9, 3.551287269604314*^9, 3.55128744640797*^9, 
   3.551330358959284*^9, {3.5513305400499353`*^9, 3.551330628468547*^9}, 
   3.551331661625308*^9, 3.551331868634966*^9, 3.5513319423919477`*^9, 
   3.5513319795034246`*^9, 3.551332963873404*^9, 3.5513330276846123`*^9, {
   3.55133313538303*^9, 3.551333150757785*^9}, {3.551333185178948*^9, 
   3.551333202150169*^9}, {3.5513332455201197`*^9, 3.5513332721373463`*^9}, 
   3.551333334056321*^9, 3.5513355620125923`*^9, 3.551336002814334*^9, 
   3.551336044493659*^9, 3.55133607892968*^9, {3.551336129754285*^9, 
   3.5513362025150213`*^9}, {3.551336239313921*^9, 3.551336264201861*^9}, 
   3.551336353005699*^9, 3.551336642239403*^9, 3.551336703563159*^9, 
   3.551336811008603*^9, 3.5513368420114613`*^9, {3.551336879736411*^9, 
   3.551336914671462*^9}, 3.551340523734376*^9, 3.5513427251875067`*^9, {
   3.5513430166517153`*^9, 3.5513430629112473`*^9}, 3.551343114901037*^9, 
   3.55152848300049*^9, 3.551528525934971*^9, {3.551528774604248*^9, 
   3.5515287887694693`*^9}, 3.551528989085909*^9, 3.55152906101967*^9, 
   3.551529155746118*^9, 3.551529198721725*^9, 3.5515297687085657`*^9, 
   3.55153114314043*^9, 3.551531190281515*^9, 3.5515313215757113`*^9, 
   3.55153138349504*^9, 3.551533049759708*^9, 3.55153890287346*^9, {
   3.551538964276251*^9, 3.551538975646102*^9}, 3.5515391073763437`*^9, {
   3.55153919303496*^9, 3.551539200411416*^9}, {3.5515392524229183`*^9, 
   3.551539274785747*^9}, 3.55153931927044*^9, 3.551539643690507*^9, 
   3.5515400212484426`*^9, 3.551540094026144*^9, 3.551540225682032*^9, 
   3.55154028726827*^9, {3.551540430898284*^9, 3.551540432995309*^9}, 
   3.551540724616878*^9, 3.55154082616982*^9, 3.55154260171939*^9, 
   3.5515426398755836`*^9, 3.5515427178694*^9, 3.551544252748621*^9, {
   3.5515442995566187`*^9, 3.551544314535264*^9}, 3.551545345280258*^9, {
   3.5515459548687487`*^9, 3.551545972934247*^9}, {3.5515465195917*^9, 
   3.551546528275547*^9}, 3.551546562713586*^9, 3.551546603262978*^9, 
   3.551717871578747*^9, 3.551718252755454*^9, 3.551718413005274*^9, 
   3.551718451117847*^9, 3.551718660119246*^9, 3.551718726302841*^9, 
   3.551718781846628*^9, 3.5517189315701227`*^9, 3.551718988091057*^9, 
   3.551719250561849*^9, 3.551719377371079*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJGegengewicht", "=", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"sm3", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"l4", "+", 
             FractionBox["l3", "2"]}], ")"}], "2"], "+", 
          FractionBox[
           SuperscriptBox["l3", "2"], "12"], "+", 
          FractionBox[
           SuperscriptBox["r1", "2"], "4"]}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"2", " ", "m3", " ", "sl4", " ", 
        RowBox[{"(", 
         RowBox[{"l4", "+", 
          FractionBox["l3", "2"]}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"m3", " ", "sl3", " ", 
        RowBox[{"(", 
         RowBox[{"l4", "+", 
          FractionBox[
           RowBox[{"2", " ", "l3"}], "3"]}], ")"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"m3", " ", "r1", " ", "sr1"}], "2"], ")"}], "2"]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.551286742334593*^9, 3.551286772562273*^9}, {
  3.55128681568318*^9, 3.551286852769719*^9}}],

Cell[BoxData["0.0010064144232545447`"], "Output",
 CellChangeTimes->{
  3.5512867968468533`*^9, {3.551287011647491*^9, 3.55128703194258*^9}, 
   3.551287068036385*^9, 3.551287269650982*^9, 3.5512874464570303`*^9, 
   3.5513303590091753`*^9, {3.5513305400988207`*^9, 3.551330628517276*^9}, 
   3.5513316616748533`*^9, 3.551331868683485*^9, 3.551331942441218*^9, 
   3.551331979550709*^9, 3.551332963924431*^9, 3.5513330277186213`*^9, {
   3.551333135431072*^9, 3.551333150807172*^9}, {3.5513331852293386`*^9, 
   3.551333202183579*^9}, {3.551333245570293*^9, 3.551333272186493*^9}, 
   3.551333334106181*^9, 3.5513355620441723`*^9, 3.5513360028651247`*^9, 
   3.551336044541376*^9, 3.551336078979803*^9, {3.551336129808505*^9, 
   3.551336202548894*^9}, {3.5513362393627577`*^9, 3.551336264235239*^9}, 
   3.551336353055827*^9, 3.551336642273868*^9, 3.5513367036083517`*^9, 
   3.551336811041831*^9, 3.551336842057781*^9, {3.551336879785831*^9, 
   3.551336914704105*^9}, 3.551340523783539*^9, 3.5513427252374983`*^9, {
   3.5513430167015057`*^9, 3.5513430629626493`*^9}, 3.551343114950611*^9, 
   3.551528483045229*^9, 3.551528525968217*^9, {3.551528774657927*^9, 
   3.551528788801922*^9}, 3.551528989119008*^9, 3.551529061069419*^9, 
   3.551529155780314*^9, 3.551529198825892*^9, 3.551529768743455*^9, 
   3.551531143192415*^9, 3.551531190312182*^9, 3.551531321623602*^9, 
   3.551531383542822*^9, 3.551533049799556*^9, 3.551538902924725*^9, {
   3.551538964325786*^9, 3.551538975757743*^9}, 3.55153910742493*^9, 
   3.5515392004600153`*^9, {3.55153925252387*^9, 3.5515392748363123`*^9}, 
   3.551539319318418*^9, 3.551539643727791*^9, 3.551540021295287*^9, 
   3.551540094075239*^9, 3.5515402257191668`*^9, 3.5515402873174143`*^9, {
   3.55154043094853*^9, 3.551540433144683*^9}, 3.5515407246685963`*^9, 
   3.551540826220785*^9, 3.55154260177037*^9, 3.5515426399272633`*^9, 
   3.551542717905963*^9, 3.551544252801504*^9, {3.551544299607812*^9, 
   3.551544314586244*^9}, 3.55154534533031*^9, {3.5515459549022217`*^9, 
   3.551545972966848*^9}, {3.551546519625293*^9, 3.55154652832477*^9}, 
   3.551546562747546*^9, 3.551546603312271*^9, 3.551717871635178*^9, 
   3.551718252788241*^9, 3.55171841305853*^9, 3.5517184511672297`*^9, 
   3.551718660166391*^9, 3.5517187263524237`*^9, 3.5517187818956823`*^9, 
   3.551718931621894*^9, 3.5517189881240683`*^9, 3.551719250611388*^9, 
   3.551719377420885*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JPerp", " ", "=", " ", 
  RowBox[{
  "JScheibe", " ", "+", " ", "JStange", " ", "+", " ", 
   "JGegengewicht"}]}]], "Input",
 CellChangeTimes->{{3.5510311698457823`*^9, 3.551031180871122*^9}}],

Cell[BoxData["0.05954355084999878`"], "Output",
 CellChangeTimes->{
  3.551031182183991*^9, 3.551031438001801*^9, 3.551031498872941*^9, 
   3.551031584564962*^9, 3.551031641011106*^9, 3.551031687315957*^9, 
   3.551031743377214*^9, 3.5510318430856867`*^9, 3.5510320354542007`*^9, 
   3.5510322439068413`*^9, 3.551032283025247*^9, 3.551032772517516*^9, 
   3.551285084997314*^9, {3.5512870116968393`*^9, 3.551287031988227*^9}, 
   3.5512870680871773`*^9, 3.551287269682541*^9, 3.5512874465058613`*^9, 
   3.551330359056514*^9, {3.551330540148638*^9, 3.551330628566452*^9}, 
   3.55133166172366*^9, 3.551331868733409*^9, 3.551331942492218*^9, 
   3.5513319796033783`*^9, 3.55133296397442*^9, 3.551333027750597*^9, {
   3.5513331354858103`*^9, 3.5513331508634167`*^9}, {3.551333185278667*^9, 
   3.5513332022164173`*^9}, {3.5513332456200657`*^9, 3.5513332722390223`*^9}, 
   3.551333334155869*^9, 3.5513355620792103`*^9, 3.551336002914352*^9, 
   3.551336044590725*^9, 3.551336079029971*^9, {3.55133612985633*^9, 
   3.5513362025822077`*^9}, {3.5513362394124126`*^9, 3.5513362642676373`*^9}, 
   3.551336353104776*^9, 3.551336642304872*^9, 3.5513367036625338`*^9, 
   3.551336811075314*^9, 3.551336842112504*^9, {3.551336879836094*^9, 
   3.55133691473752*^9}, 3.551340523833435*^9, 3.5513427252712803`*^9, {
   3.551343016750785*^9, 3.551343063008354*^9}, 3.551343114999106*^9, 
   3.551528483095726*^9, 3.551528526000113*^9, {3.551528774704384*^9, 
   3.551528788834362*^9}, 3.5515289891524353`*^9, 3.551529061119008*^9, 
   3.551529155813048*^9, 3.5515291990062323`*^9, 3.551529768790916*^9, 
   3.551531143225295*^9, 3.5515311903644733`*^9, 3.551531321676448*^9, 
   3.551531383594371*^9, 3.551533049832841*^9, 3.551538902979355*^9, {
   3.5515389643755293`*^9, 3.551538976019932*^9}, 3.5515391074752827`*^9, 
   3.55153920051622*^9, {3.5515392526690283`*^9, 3.5515392748863087`*^9}, 
   3.551539319370775*^9, 3.551539643772642*^9, 3.5515400213471813`*^9, 
   3.551540094124669*^9, 3.5515402257652903`*^9, 3.5515402873524313`*^9, {
   3.551540430998251*^9, 3.551540433294029*^9}, 3.55154072471736*^9, 
   3.551540826271966*^9, 3.551542601820375*^9, 3.551542639979738*^9, 
   3.5515427179501753`*^9, 3.551544252849862*^9, {3.55154429965827*^9, 
   3.551544314634046*^9}, 3.5515453453805513`*^9, {3.551545954935789*^9, 
   3.551545973016755*^9}, {3.551546519657892*^9, 3.551546528357854*^9}, 
   3.551546562780946*^9, 3.551546603361986*^9, 3.551717871680913*^9, 
   3.5517182528219757`*^9, 3.5517184131611357`*^9, 3.5517184512161293`*^9, 
   3.551718660219195*^9, 3.551718726403037*^9, 3.551718781951235*^9, 
   3.551718931688488*^9, 3.551718988159204*^9, 3.551719250660563*^9, 
   3.5517193774680433`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJPerp", "=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox["sJGegengewicht", "2"], "+", 
    SuperscriptBox["sJScheibe", "2"], "+", 
    SuperscriptBox["sJStange", "2"]}]]}]], "Input",
 CellChangeTimes->{{3.551287082212989*^9, 3.551287099917238*^9}, {
  3.551287234213682*^9, 3.551287237733151*^9}}],

Cell[BoxData["0.001254608284414192`"], "Output",
 CellChangeTimes->{
  3.55128710067868*^9, 3.551287269716036*^9, 3.551287446537027*^9, 
   3.55133035910614*^9, {3.5513305401986103`*^9, 3.551330628618647*^9}, 
   3.551331661774663*^9, 3.5513318687836742`*^9, 3.551331942541767*^9, 
   3.551331979653019*^9, 3.55133296401165*^9, 3.551333027784349*^9, {
   3.5513331355302143`*^9, 3.5513331509064903`*^9}, {3.5513331853330297`*^9, 
   3.551333202250215*^9}, {3.5513332456738987`*^9, 3.551333272286833*^9}, 
   3.551333334205512*^9, 3.551335562110649*^9, 3.551336002964363*^9, 
   3.551336044640894*^9, 3.551336079079221*^9, {3.551336129906062*^9, 
   3.5513362026173067`*^9}, {3.551336239466483*^9, 3.55133626430121*^9}, 
   3.5513363531557093`*^9, 3.551336642338439*^9, 3.551336703709059*^9, 
   3.551336811108304*^9, 3.551336842157617*^9, {3.551336879885749*^9, 
   3.551336914771081*^9}, 3.551340523882896*^9, 3.55134272530357*^9, {
   3.551343016800989*^9, 3.551343063048594*^9}, 3.551343115049448*^9, 
   3.551528483144903*^9, 3.5515285260331497`*^9, {3.5515287747576027`*^9, 
   3.551528788868334*^9}, 3.55152898918531*^9, 3.551529061167161*^9, 
   3.551529155846428*^9, 3.551529199101865*^9, 3.551529768823749*^9, 
   3.5515311432766333`*^9, 3.5515311903978148`*^9, 3.551531321723308*^9, 
   3.5515313836447144`*^9, 3.551533049878706*^9, 3.5515389030252237`*^9, {
   3.551538964409485*^9, 3.551538976422696*^9}, 3.551539107524561*^9, 
   3.551539200584359*^9, {3.551539252718247*^9, 3.551539274934263*^9}, 
   3.551539319417551*^9, 3.551539643825068*^9, 3.5515400213828382`*^9, 
   3.551540094176105*^9, 3.5515402258147793`*^9, 3.5515402874015493`*^9, {
   3.551540431047022*^9, 3.55154043355757*^9}, 3.55154072476724*^9, 
   3.551540826319447*^9, 3.551542601871272*^9, 3.551542640028722*^9, 
   3.55154271800104*^9, 3.551544252898279*^9, {3.5515442997063227`*^9, 
   3.5515443146856213`*^9}, 3.5515453454126463`*^9, {3.551545954968631*^9, 
   3.551545973048737*^9}, {3.5515465197074423`*^9, 3.551546528445917*^9}, 
   3.5515465628309813`*^9, 3.551546603393593*^9, 3.551717871729385*^9, 
   3.551718252855179*^9, 3.551718413238913*^9, 3.5517184512726727`*^9, 
   3.551718660268305*^9, 3.551718726454529*^9, 3.551718781999525*^9, 
   3.551718931737979*^9, 3.551718988190299*^9, 3.551719250711018*^9, 
   3.551719377519021*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pendelschwingung", "Subtitle",
 CellChangeTimes->{{3.551295977475192*^9, 3.5512959795633583`*^9}, {
  3.5513298090178423`*^9, 3.551329811210994*^9}}],

Cell["\<\
Das Anschraubgewicht hat eine L\[ADoubleDot]nge von 3.0 cm.\
\>", "Subsubtitle",
 CellChangeTimes->{{3.5515499089262133`*^9, 3.551549948659781*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JFP", "=", 
  RowBox[{
   FractionBox[
    RowBox[{"g", " ", "m4", " ", 
     RowBox[{"(", 
      RowBox[{"r2", "+", "0.015"}], ")"}], " ", 
     SuperscriptBox["TPendel", "2"]}], 
    RowBox[{"4", " ", 
     SuperscriptBox["\[Pi]", "2"]}]], "-", 
   RowBox[{"m4", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"r2", "+", "0.015"}], ")"}], "2"]}]}]}]], "Input",
 CellChangeTimes->{{3.551330273440028*^9, 3.55133035394199*^9}, {
  3.551330467789215*^9, 3.551330473154224*^9}, {3.551331203517386*^9, 
  3.551331207535882*^9}, {3.55152903743417*^9, 3.551529059311618*^9}}],

Cell[BoxData["0.010134168773588406`"], "Output",
 CellChangeTimes->{{3.551330355674629*^9, 3.551330359258046*^9}, 
   3.5513304189433804`*^9, {3.5513304737739277`*^9, 3.551330504393361*^9}, {
   3.551330540348942*^9, 3.5513306287653093`*^9}, 3.5513316618247633`*^9, 
   3.551331868835129*^9, 3.551331942591852*^9, 3.5513319797021103`*^9, 
   3.551332964056423*^9, 3.551333027817553*^9, {3.551333135584387*^9, 
   3.551333150961342*^9}, {3.551333185378874*^9, 3.5513332022826357`*^9}, {
   3.551333245718103*^9, 3.5513332723403883`*^9}, 3.551333334255692*^9, 
   3.551335562228196*^9, 3.551336003015081*^9, 3.5513360446932287`*^9, 
   3.551336079128098*^9, {3.551336129954796*^9, 3.551336202647523*^9}, {
   3.551336239512237*^9, 3.5513362643363123`*^9}, 3.551336353204994*^9, 
   3.5513366423725*^9, 3.551336703762394*^9, 3.551336811140991*^9, 
   3.551336842212474*^9, {3.551336879935845*^9, 3.551336914803007*^9}, 
   3.5513405239313097`*^9, 3.5513427253376703`*^9, {3.551342989581983*^9, 
   3.551343063091742*^9}, 3.551343115100025*^9, 3.5515284831947613`*^9, 
   3.551528526066141*^9, {3.5515287748034973`*^9, 3.5515287889014387`*^9}, 
   3.551528989218646*^9, {3.551529046105555*^9, 3.551529061205558*^9}, 
   3.55152915588019*^9, 3.5515291991892557`*^9, 3.5515297689397697`*^9, 
   3.551531143321007*^9, 3.551531190430379*^9, 3.551531321772747*^9, 
   3.551531383693959*^9, 3.551533049911743*^9, 3.551538903073132*^9, {
   3.5515389644479923`*^9, 3.551538976494869*^9}, 3.551539107576692*^9, 
   3.551539200631109*^9, {3.5515392527796783`*^9, 3.551539274984125*^9}, 
   3.55153931946737*^9, 3.5515396438741207`*^9, 3.5515400214284477`*^9, 
   3.55154009422484*^9, 3.551540225864876*^9, 3.551540287451561*^9, {
   3.551540431079056*^9, 3.551540433604254*^9}, 3.5515407248171177`*^9, 
   3.5515408263726187`*^9, 3.551542601917857*^9, 3.5515426400768557`*^9, 
   3.551542718049972*^9, 3.551544252947505*^9, {3.551544299756548*^9, 
   3.551544314734088*^9}, 3.551545345445613*^9, {3.55154595500147*^9, 
   3.5515459731061163`*^9}, {3.55154651975782*^9, 3.551546528545759*^9}, 
   3.551546562863222*^9, 3.55154660342686*^9, 3.551717871780237*^9, 
   3.551718252887541*^9, 3.551718413288538*^9, 3.551718451314827*^9, 
   3.551718660373399*^9, 3.55171872650566*^9, 3.5517187820458612`*^9, 
   3.551718931787931*^9, 3.551718988223818*^9, 3.551719250760995*^9, 
   3.551719377568482*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJFP", "=", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"g", " ", "m4", " ", "sr2", " ", 
          SuperscriptBox["TPendel", "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Pi]", "2"]}]], "-", 
        RowBox[{"2", " ", "m4", " ", "r2", " ", "sr2"}]}], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", 
         RowBox[{"2", " ", 
          SuperscriptBox["\[Pi]", "2"]}]], 
        RowBox[{
        "g", " ", "m4", " ", "r2", " ", "sTPendel", " ", "TPendel"}]}], ")"}],
       "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"g", " ", "r2", " ", "sm4", " ", 
          SuperscriptBox["TPendel", "2"]}], 
         RowBox[{"4", " ", 
          SuperscriptBox["\[Pi]", "2"]}]], "-", 
        RowBox[{
         SuperscriptBox["r2", "2"], " ", "sm4"}]}], ")"}], "2"]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.551331068824544*^9, 3.5513311978733*^9}}],

Cell[BoxData["0.0003559149307068262`"], "Output",
 CellChangeTimes->{
  3.551331188807062*^9, 3.551331661873568*^9, 3.551331868884036*^9, 
   3.551331942641444*^9, 3.551331979751627*^9, 3.55133296410548*^9, 
   3.5513330278518248`*^9, {3.551333135629601*^9, 3.551333151005739*^9}, {
   3.5513331854276257`*^9, 3.551333202316514*^9}, {3.551333245772675*^9, 
   3.5513332723863173`*^9}, 3.551333334306569*^9, 3.55133556225975*^9, 
   3.5513360030642233`*^9, 3.551336044739777*^9, 3.551336079183033*^9, {
   3.551336130009159*^9, 3.551336202683601*^9}, {3.5513362396154013`*^9, 
   3.5513362643672333`*^9}, 3.5513363532534122`*^9, 3.551336642404727*^9, 
   3.551336703810156*^9, 3.551336811174067*^9, 3.551336842259083*^9, {
   3.551336879985799*^9, 3.551336914835877*^9}, 3.5513405239868526`*^9, 
   3.551342725398591*^9, {3.55134297991814*^9, 3.551342985000168*^9}, {
   3.551343016900424*^9, 3.551343063144526*^9}, 3.551343115148635*^9, 
   3.5515284832441473`*^9, 3.5515285260997467`*^9, {3.551528774852707*^9, 
   3.551528788933913*^9}, 3.55152898925249*^9, 3.551529061250636*^9, 
   3.5515291559143543`*^9, 3.5515291992519827`*^9, 3.551529768972867*^9, 
   3.5515311433543777`*^9, 3.5515311904590387`*^9, 3.5515313218243732`*^9, 
   3.551531383743197*^9, 3.551533049944792*^9, 3.5515389032039337`*^9, {
   3.551538964492453*^9, 3.551538976560451*^9}, 3.5515391076550713`*^9, 
   3.551539200731559*^9, {3.551539252865197*^9, 3.551539275036515*^9}, 
   3.551539319519503*^9, 3.5515396439254847`*^9, 3.551540021478839*^9, 
   3.5515400942738934`*^9, 3.551540225915609*^9, 3.551540287489319*^9, {
   3.551540431132872*^9, 3.551540433654297*^9}, 3.5515407248549643`*^9, 
   3.551540826423547*^9, 3.551542601970126*^9, 3.551542640125698*^9, 
   3.551542718100905*^9, 3.551544252985628*^9, {3.551544299793427*^9, 
   3.551544314783246*^9}, 3.551545345477364*^9, {3.551545955051709*^9, 
   3.551545973150358*^9}, {3.5515465197909803`*^9, 3.55154652872901*^9}, 
   3.551546562895248*^9, 3.551546603462969*^9, 3.551717871832447*^9, 
   3.551718252921875*^9, 3.55171841333815*^9, 3.551718451366768*^9, 
   3.551718660521665*^9, 3.5517187265555*^9, 3.551718782096013*^9, 
   3.551718931838044*^9, 3.551718988257225*^9, 3.551719250810974*^9, 
   3.551719377619924*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Pr\[ADoubleDot]zession", "Subtitle"]], "Subsubtitle",
 CellChangeTimes->{{3.551331276282488*^9, 3.551331277648732*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JFPr1", " ", "=", " ", 
  FractionBox[
   RowBox[{"g", "*", "mP1", "*", "l2"}], "mu1"]}]], "Input",
 CellChangeTimes->{{3.5513327322875357`*^9, 3.551332768030774*^9}}],

Cell[BoxData["0.011187336439650222`"], "Output",
 CellChangeTimes->{
  3.551540742927199*^9, 3.551540826483471*^9, 3.551542602020979*^9, 
   3.5515426401753283`*^9, 3.5515427181503563`*^9, 3.551544253030448*^9, {
   3.5515442998389177`*^9, 3.55154431483215*^9}, 3.551545345511335*^9, {
   3.551545955114662*^9, 3.551545973246707*^9}, {3.5515465200115833`*^9, 
   3.551546528887878*^9}, 3.551546563117394*^9, 3.551546603849699*^9, 
   3.5517178719277077`*^9, 3.55171825343579*^9, 3.551718413421788*^9, 
   3.551718451512805*^9, 3.5517186606134987`*^9, 3.5517187266519127`*^9, 
   3.5517187821746492`*^9, 3.551718931915839*^9, 3.551718988339939*^9, 
   3.551719250907078*^9, 3.5517193777327213`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJFPR1", "=", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"g", " ", "l2", " ", "mP1", " ", "smu1"}], 
        SuperscriptBox["mu1", "2"]], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"g", " ", "l2", " ", "smP"}], "mu1"], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"g", " ", "mP1", " ", "sl2"}], "mu1"], ")"}], "2"]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5513330688790894`*^9, 3.551333118758953*^9}, {
  3.551333533095348*^9, 3.5513335362823153`*^9}}],

Cell[BoxData["0.00035197944086326797`"], "Output",
 CellChangeTimes->{{3.5513331200866756`*^9, 3.551333151105501*^9}, {
   3.551333185530788*^9, 3.551333202382174*^9}, {3.551333245924272*^9, 
   3.55133327248915*^9}, 3.5513333344042*^9, 3.551335562395051*^9, 
   3.551336003162763*^9, 3.5513360448410463`*^9, 3.551336079277767*^9, {
   3.551336130157435*^9, 3.5513362027482443`*^9}, {3.551336239991541*^9, 
   3.551336264434593*^9}, 3.551336353342565*^9, 3.551336642472742*^9, 
   3.551336703907981*^9, 3.551336811239725*^9, 3.551336842360811*^9, {
   3.55133688008819*^9, 3.551336914905129*^9}, 3.551340524078754*^9, 
   3.551342725515592*^9, {3.551343017000049*^9, 3.551343063244576*^9}, 
   3.551343115255266*^9, 3.551528483349078*^9, 3.551528526167096*^9, {
   3.551528774952854*^9, 3.551528789001556*^9}, 3.5515289893181467`*^9, 
   3.551529061349435*^9, 3.5515291559801493`*^9, 3.551529199385553*^9, 
   3.551529769038396*^9, 3.551531143421122*^9, 3.5515311905279293`*^9, 
   3.5515313219993477`*^9, 3.551531383842742*^9, 3.551533050011516*^9, 
   3.551538903334733*^9, {3.5515389646053762`*^9, 3.551538976650691*^9}, 
   3.551539107756734*^9, 3.551539201404402*^9, {3.551539252956328*^9, 
   3.551539275133543*^9}, 3.551539319618938*^9, 3.551539644022193*^9, 
   3.551540021578691*^9, 3.551540094374669*^9, 3.551540226015484*^9, 
   3.551540287584701*^9, {3.551540431213904*^9, 3.551540433753923*^9}, 
   3.551540725004767*^9, 3.551540826535096*^9, 3.551542602066535*^9, 
   3.5515426402256327`*^9, 3.5515427181994123`*^9, 3.551544253081841*^9, {
   3.5515442998899813`*^9, 3.551544314885561*^9}, 3.5515453455461073`*^9, {
   3.5515459551492977`*^9, 3.55154597328094*^9}, {3.55154652023878*^9, 
   3.551546528953157*^9}, 3.551546563343564*^9, 3.551546604044413*^9, 
   3.5517178720600367`*^9, 3.5517182534858837`*^9, 3.551718413471154*^9, 
   3.5517184515705757`*^9, 3.551718660702722*^9, 3.55171872670217*^9, 
   3.551718782213965*^9, 3.551718931955023*^9, 3.551718988372414*^9, 
   3.551719250962421*^9, 3.551719377785236*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JFPr2", " ", "=", " ", 
  FractionBox[
   RowBox[{"g", "*", "mP2", "*", "l2"}], "mu2"]}]], "Input",
 CellChangeTimes->{{3.5513332171057053`*^9, 3.55133321988948*^9}}],

Cell[BoxData["0.01024937502741108`"], "Output",
 CellChangeTimes->{{3.551333231437224*^9, 3.551333272535286*^9}, 
   3.551333334441801*^9, 3.551335562431432*^9, 3.551336003199527*^9, 
   3.5513360448903303`*^9, 3.551336079326889*^9, {3.551336130306349*^9, 
   3.551336202780919*^9}, {3.551336240042706*^9, 3.551336264500785*^9}, 
   3.551336353385804*^9, 3.551336642505416*^9, 3.551336703960175*^9, 
   3.551336811274366*^9, 3.551336842409843*^9, {3.551336880134623*^9, 
   3.5513369149382887`*^9}, 3.5513405241341887`*^9, 3.551342725646813*^9, {
   3.5513430170496073`*^9, 3.551343063293828*^9}, 3.551343115299685*^9, 
   3.551528483393631*^9, 3.5515285262002068`*^9, {3.551528775006668*^9, 
   3.5515287890348577`*^9}, 3.551528989351655*^9, 3.551529061416889*^9, 
   3.551529156012854*^9, 3.5515291994437532`*^9, 3.551529769072858*^9, 
   3.5515311434525967`*^9, 3.551531190559473*^9, 3.55153132209385*^9, 
   3.551531383892129*^9, 3.55153305004471*^9, 3.551538903428618*^9, {
   3.551538964641891*^9, 3.5515389766849422`*^9}, 3.551539107808733*^9, 
   3.551539201440894*^9, {3.551539252989029*^9, 3.551539275183468*^9}, 
   3.5515393196690407`*^9, 3.5515396440599422`*^9, 3.551540021629438*^9, 
   3.551540094466457*^9, 3.5515402260635557`*^9, 3.5515402876337233`*^9, {
   3.551540431266349*^9, 3.551540433801598*^9}, 3.551540725318926*^9, 
   3.551540826585582*^9, 3.551542602117957*^9, 3.551542640273899*^9, 
   3.551542718286532*^9, 3.551544253158807*^9, {3.5515442999405327`*^9, 
   3.551544314960763*^9}, 3.551545345634845*^9, {3.5515459551843777`*^9, 
   3.551545973320833*^9}, {3.5515465202884693`*^9, 3.551546529006884*^9}, 
   3.551546563394216*^9, 3.5515466040774593`*^9, 3.5517178721120367`*^9, 
   3.551718253534992*^9, 3.5517184135090847`*^9, 3.5517184516153593`*^9, 
   3.551718660803681*^9, 3.5517187267554893`*^9, 3.551718782260622*^9, 
   3.551718932032696*^9, 3.551718988408804*^9, 3.551719251009094*^9, 
   3.5517193778225927`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJFPR2", "=", 
  RowBox[{"\[Sqrt]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"g", " ", "l2", " ", "mP2", " ", "smu2"}], 
        SuperscriptBox["mu2", "2"]], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"g", " ", "l2", " ", "smP"}], "mu2"], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"g", " ", "mP2", " ", "sl2"}], "mu2"], ")"}], "2"]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5513332881720057`*^9, 3.551333315409259*^9}, {
  3.551333526322879*^9, 3.551333529341939*^9}}],

Cell[BoxData["0.0008182473804582045`"], "Output",
 CellChangeTimes->{
  3.55133333451803*^9, 3.551335562478098*^9, 3.551336003275487*^9, 
   3.5513360449457684`*^9, 3.551336079379965*^9, {3.551336130567494*^9, 
   3.551336202816081*^9}, {3.551336240077944*^9, 3.551336264623684*^9}, 
   3.5513363534378853`*^9, 3.5513366425380983`*^9, 3.5513367040098763`*^9, 
   3.5513368113084106`*^9, 3.551336842460409*^9, {3.551336880184309*^9, 
   3.5513369150025578`*^9}, 3.551340524181058*^9, 3.551342725789432*^9, {
   3.551343017099367*^9, 3.551343063343607*^9}, 3.551343115378572*^9, 
   3.551528483526161*^9, 3.551528526234118*^9, {3.551528775052127*^9, 
   3.551528789067059*^9}, 3.551528989384244*^9, 3.5515290614528303`*^9, 
   3.551529156046009*^9, 3.5515291994856253`*^9, 3.551529769105282*^9, 
   3.55153114348809*^9, 3.551531190591791*^9, 3.551531322170459*^9, 
   3.5515313839677677`*^9, 3.551533050078072*^9, 3.551538903476478*^9, {
   3.551538964674162*^9, 3.5515389767363997`*^9}, 3.551539107866069*^9, 
   3.551539201490542*^9, {3.55153925303432*^9, 3.55153927523328*^9}, 
   3.5515393197188873`*^9, 3.551539644105542*^9, 3.551540021679213*^9, 
   3.5515400945047293`*^9, 3.551540226184148*^9, 3.5515402876844893`*^9, {
   3.551540431424654*^9, 3.551540433853318*^9}, 3.551540725408876*^9, 
   3.551540826634728*^9, 3.551542602196065*^9, 3.5515426403515797`*^9, 
   3.5515427185763187`*^9, 3.551544253197432*^9, {3.551544300016797*^9, 
   3.5515443150144663`*^9}, 3.551545345883197*^9, {3.5515459552333508`*^9, 
   3.55154597336668*^9}, {3.551546520342038*^9, 3.551546529056106*^9}, 
   3.551546563430601*^9, 3.55154660411189*^9, 3.5517178721605864`*^9, 
   3.551718253584312*^9, 3.55171841354112*^9, 3.551718451663813*^9, 
   3.551718660849208*^9, 3.551718726800292*^9, 3.551718782310506*^9, 
   3.551718932085579*^9, 3.551718988439859*^9, 3.551719251090403*^9, 
   3.551719377872554*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JFPr3", " ", "=", " ", 
  FractionBox[
   RowBox[{"g", "*", "mP3", "*", "l2"}], "mu3"]}]], "Input",
 CellChangeTimes->{{3.551333222289003*^9, 3.55133322904113*^9}, {
  3.551333277232448*^9, 3.551333277791098*^9}}],

Cell[BoxData["0.010039139615782622`"], "Output",
 CellChangeTimes->{{3.5513332327646523`*^9, 3.5513332799224567`*^9}, 
   3.551333334552786*^9, 3.5513355625078278`*^9, 3.5513360033120527`*^9, 
   3.5513360450381308`*^9, 3.551336079425089*^9, {3.551336130604937*^9, 
   3.551336202881645*^9}, {3.5513362401093884`*^9, 3.551336264764708*^9}, 
   3.55133635356787*^9, 3.5513366425712547`*^9, 3.5513367040900297`*^9, 
   3.551336811339859*^9, 3.5513368427391853`*^9, {3.5513368802336893`*^9, 
   3.55133691512429*^9}, 3.5513405242311363`*^9, 3.551342725834414*^9, {
   3.5513430171789703`*^9, 3.55134306342212*^9}, 3.55134311543176*^9, 
   3.55152848358296*^9, 3.551528526266893*^9, {3.5515287751347513`*^9, 
   3.55152878910015*^9}, 3.551528989417972*^9, 3.551529061498519*^9, 
   3.5515291560790243`*^9, 3.551529199536536*^9, 3.5515297691390953`*^9, 
   3.5515311435237083`*^9, 3.551531190624384*^9, 3.551531322260604*^9, 
   3.551531384110291*^9, 3.55153305011066*^9, 3.551538903543729*^9, {
   3.551538964727928*^9, 3.551538976832263*^9}, 3.5515391079335203`*^9, 
   3.551539201525378*^9, {3.551539253068624*^9, 3.551539275284148*^9}, 
   3.5515393197668047`*^9, 3.551539644155096*^9, 3.551540021738626*^9, 
   3.55154009455444*^9, 3.5515402264496403`*^9, 3.551540287804459*^9, {
   3.551540431463826*^9, 3.551540433903281*^9}, 3.5515407254638*^9, 
   3.5515408266843433`*^9, 3.551542602250345*^9, 3.551542640393633*^9, 
   3.551542718630986*^9, 3.551544253230084*^9, {3.551544300055509*^9, 
   3.551544315066185*^9}, 3.551545346263769*^9, {3.551545955267783*^9, 
   3.551545973446148*^9}, {3.551546520388269*^9, 3.551546529106443*^9}, 
   3.5515465634623203`*^9, 3.5515466041478567`*^9, 3.5517178722119427`*^9, 
   3.55171825362004*^9, 3.551718413572872*^9, 3.5517184517141848`*^9, 
   3.551718660896886*^9, 3.551718726852086*^9, 3.551718782360952*^9, 
   3.551718932137445*^9, 3.551718988472023*^9, 3.551719251144476*^9, 
   3.551719377917829*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJFPR3", "=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"g", " ", "l2", " ", "mP3", " ", "smu3"}], 
       SuperscriptBox["mu3", "2"]], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"g", " ", "l2", " ", "smP"}], "mu3"], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"g", " ", "mP3", " ", "sl2"}], "mu3"], ")"}], 
     "2"]}]]}]], "Input",
 CellChangeTimes->{{3.5513332921462*^9, 3.551333332688705*^9}, {
  3.5513335145163927`*^9, 3.5513335227296*^9}}],

Cell[BoxData["0.00032331375507481955`"], "Output",
 CellChangeTimes->{
  3.551333334608714*^9, 3.551335562541445*^9, 3.5513360033616133`*^9, 
   3.551336045094585*^9, 3.5513360796134033`*^9, {3.5513361306370707`*^9, 
   3.55133620300246*^9}, {3.551336240141939*^9, 3.5513362648478518`*^9}, 
   3.551336353622739*^9, 3.551336642639998*^9, 3.551336704142373*^9, 
   3.5513368113733788`*^9, 3.5513368427933903`*^9, {3.5513368803141203`*^9, 
   3.5513369153732862`*^9}, 3.551340524310964*^9, 3.5513427258708067`*^9, {
   3.55134301723102*^9, 3.5513430634578037`*^9}, 3.55134311547921*^9, 
   3.551528483627122*^9, 3.551528526299768*^9, {3.5515287751898327`*^9, 
   3.551528789135157*^9}, 3.551528989451395*^9, 3.55152906153541*^9, 
   3.551529156111512*^9, 3.5515291996031733`*^9, 3.551529769237804*^9, 
   3.551531143570877*^9, 3.551531190657443*^9, 3.551531322338544*^9, 
   3.551531384396796*^9, 3.55153305014397*^9, 3.5515389036375113`*^9, {
   3.5515389648358192`*^9, 3.5515389769682903`*^9}, 3.55153910799724*^9, 
   3.551539201558095*^9, {3.5515392531026773`*^9, 3.55153927533222*^9}, 
   3.551539319817082*^9, 3.551539644421301*^9, 3.551540021777421*^9, 
   3.551540094604254*^9, 3.551540226509697*^9, 3.551540287954894*^9, {
   3.5515404315123158`*^9, 3.551540433955669*^9}, 3.55154072549885*^9, 
   3.551540826734764*^9, 3.551542602302512*^9, 3.551542640457099*^9, 
   3.551542718671938*^9, 3.551544253279414*^9, {3.5515443000894957`*^9, 
   3.551544315114814*^9}, 3.551545346362405*^9, {3.551545955300761*^9, 
   3.5515459734833937`*^9}, {3.551546520438129*^9, 3.551546529141317*^9}, 
   3.551546563500578*^9, 3.55154660419349*^9, 3.551717872261806*^9, 
   3.551718253655044*^9, 3.551718413605419*^9, 3.551718451766827*^9, 
   3.551718660937018*^9, 3.551718726901084*^9, 3.551718782463893*^9, 
   3.5517189321862707`*^9, 3.551718988505514*^9, 3.551719251190935*^9, 
   3.551719377972076*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Tr\[ADoubleDot]gheitsmoment", "Subtitle",
 CellChangeTimes->{{3.5513362896405354`*^9, 3.55133629985391*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JF", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     FractionBox["JFP", 
      SuperscriptBox["sJFP", "2"]], "+", 
     FractionBox["JFPr1", 
      SuperscriptBox["sJFPR1", "2"]], "+", 
     FractionBox["JFPr2", 
      SuperscriptBox["sJFPR2", "2"]], "+", 
     FractionBox["JFPr3", 
      SuperscriptBox["sJFPR3", "2"]], "+", 
     FractionBox["JFT", 
      SuperscriptBox["sJFT", "2"]]}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["sJFP", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFPR1", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFPR2", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFPR3", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFT", "2"]]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5513363165405483`*^9, 3.5513363501260767`*^9}, {
  3.551336425814149*^9, 3.551336561525692*^9}, {3.5513367531134243`*^9, 
  3.5513367537924747`*^9}, {3.5513430065902233`*^9, 3.551343037718853*^9}, {
  3.551343070975687*^9, 3.551343112512973*^9}}],

Cell[BoxData["0.010294863674233747`"], "Output",
 CellChangeTimes->{
  3.5513363536704273`*^9, 3.55133656253728*^9, 3.551336642709923*^9, 
   3.55133670419254*^9, 3.551336754602281*^9, 3.551336811407208*^9, 
   3.551336842840663*^9, {3.551336880420293*^9, 3.5513369157345123`*^9}, 
   3.5513405243502817`*^9, {3.551342725935107*^9, 3.551342741908057*^9}, {
   3.5513430024669647`*^9, 3.5513431155353117`*^9}, 3.551528483675729*^9, 
   3.551528526332472*^9, {3.551528775234394*^9, 3.551528789167972*^9}, 
   3.551528989483534*^9, 3.5515290615807323`*^9, 3.5515291561463346`*^9, 
   3.5515291997261047`*^9, 3.55152976927179*^9, 3.551531143603655*^9, 
   3.551531190691833*^9, 3.551531322384794*^9, 3.55153138453154*^9, 
   3.551533050177268*^9, 3.551538903685852*^9, {3.551538964932563*^9, 
   3.551538977063716*^9}, 3.5515391080670853`*^9, 3.5515392015911713`*^9, {
   3.551539253134037*^9, 3.551539275437636*^9}, 3.551539319894112*^9, 
   3.551539644473901*^9, 3.551540021827668*^9, 3.551540094653221*^9, 
   3.551540226561862*^9, 3.551540288165902*^9, {3.5515404315628242`*^9, 
   3.551540434055243*^9}, 3.551540725530817*^9, 3.551540826788657*^9, 
   3.5515426023553333`*^9, 3.551542640507605*^9, 3.55154271871624*^9, 
   3.551544253331106*^9, {3.551544300119875*^9, 3.551544315163694*^9}, 
   3.55154534640884*^9, {3.551545955371737*^9, 3.551545973587592*^9}, {
   3.5515465204869947`*^9, 3.5515465291747303`*^9}, 3.551546563545888*^9, 
   3.551546604226616*^9, 3.551717872316071*^9, 3.551718253686763*^9, 
   3.551718413652904*^9, 3.55171845181413*^9, 3.5517186610121326`*^9, 
   3.551718726938426*^9, 3.5517187825653133`*^9, 3.551718932233245*^9, 
   3.551718988538636*^9, 3.551719251246002*^9, 3.551719378022818*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sJF", "=", 
  SqrtBox[
   FractionBox["1", 
    RowBox[{
     FractionBox["1", 
      SuperscriptBox["sJFP", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFPR1", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFPR2", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFPR3", "2"]], "+", 
     FractionBox["1", 
      SuperscriptBox["sJFT", "2"]]}]]]}]], "Input",
 CellChangeTimes->{{3.551336718305187*^9, 3.5513367635177927`*^9}, {
  3.5513430571622562`*^9, 3.5513430604146433`*^9}, {3.551343124261587*^9, 
  3.5513431350719748`*^9}}],

Cell[BoxData["0.00016550000564660036`"], "Output",
 CellChangeTimes->{{3.551336735547574*^9, 3.551336764580351*^9}, 
   3.551336811439549*^9, 3.551336842888856*^9, {3.5513368805188217`*^9, 
   3.5513369158009043`*^9}, 3.5513405243969297`*^9, {3.55134272608852*^9, 
   3.551342743534317*^9}, {3.5513430173329372`*^9, 3.5513430635579653`*^9}, 
   3.551343115581276*^9, 3.551528483726749*^9, 3.55152852636551*^9, {
   3.551528775289975*^9, 3.551528789201478*^9}, 3.5515289895174313`*^9, 
   3.551529061635376*^9, 3.551529156178732*^9, 3.5515291998682127`*^9, 
   3.551529769304843*^9, 3.551531143666891*^9, 3.551531190728181*^9, 
   3.551531322434313*^9, 3.551531384590638*^9, 3.5515330502103987`*^9, 
   3.551538903736565*^9, {3.551538965065384*^9, 3.5515389771356783`*^9}, 
   3.551539108130929*^9, 3.551539201628916*^9, {3.551539253167399*^9, 
   3.5515392757219763`*^9}, 3.55153932002133*^9, 3.551539644590691*^9, 
   3.551540021878203*^9, 3.5515400947055597`*^9, 3.5515402266116533`*^9, 
   3.551540288215208*^9, {3.551540431665635*^9, 3.5515404341556187`*^9}, 
   3.5515407255772743`*^9, 3.5515408268314457`*^9, 3.551542602472157*^9, 
   3.551542640557187*^9, 3.5515427187584763`*^9, 3.551544253379603*^9, {
   3.551544300152321*^9, 3.551544315214151*^9}, 3.551545346459197*^9, {
   3.551545955570713*^9, 3.551545973720899*^9}, {3.551546520524897*^9, 
   3.551546529207739*^9}, 3.551546563577775*^9, 3.551546604259766*^9, 
   3.5517178723622437`*^9, 3.551718253751277*^9, 3.55171841370336*^9, 
   3.5517184518614807`*^9, 3.551718661063994*^9, 3.551718726986875*^9, 
   3.55171878260926*^9, 3.551718932285487*^9, 3.5517189886080112`*^9, 
   3.551719251344983*^9, 3.551719378099618*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\nNutation", "Subtitle"]], "Subsubtitle",
 CellChangeTimes->{{3.551331438285128*^9, 3.551331444635929*^9}, 
   3.551336314637929*^9, {3.551529329796164*^9, 3.5515293306171103`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Alpha", "=", 
  RowBox[{"ArcSin", "[", 
   FractionBox["dNut", 
    RowBox[{"2", "*", "l7"}]], "]"}]}]], "Input",
 CellChangeTimes->{{3.5513313480028276`*^9, 3.551331365479871*^9}, {
  3.551331509406888*^9, 3.551331555290552*^9}, {3.551331608089617*^9, 
  3.551331682483132*^9}, {3.5513317175811443`*^9, 3.55133180686331*^9}, {
  3.5513318746583138`*^9, 3.5513318749565268`*^9}}],

Cell[BoxData["0.1383721773851071`"], "Output",
 CellChangeTimes->{{3.551331668094469*^9, 3.551331683254863*^9}, {
   3.5513318689326887`*^9, 3.551331880151597*^9}, 3.551331942691312*^9, 
   3.551331979803215*^9, 3.551332964189454*^9, 3.551333027950564*^9, {
   3.551333135935569*^9, 3.551333151155517*^9}, {3.551333185577188*^9, 
   3.551333202416038*^9}, {3.551333246335545*^9, 3.5513332726396637`*^9}, 
   3.551333334654613*^9, 3.551335562578475*^9, 3.551336003412611*^9, 
   3.5513360451934566`*^9, 3.551336079697208*^9, {3.551336130682818*^9, 
   3.5513362032108393`*^9}, {3.5513362401769133`*^9, 3.55133626489987*^9}, 
   3.551336353704619*^9, 3.5513366430431223`*^9, 3.5513367042415543`*^9, 
   3.5513368114732847`*^9, 3.5513368429921713`*^9, {3.5513368806185837`*^9, 
   3.551336915866085*^9}, 3.551340524447047*^9, 3.5513427261320133`*^9, {
   3.551343017382204*^9, 3.551343063607812*^9}, 3.551343115630025*^9, 
   3.551528483775085*^9, 3.55152852640023*^9, {3.551528775334425*^9, 
   3.551528789233392*^9}, 3.551528989550974*^9, 3.551529061681519*^9, 
   3.551529156212817*^9, 3.551529199916353*^9, 3.551529769337812*^9, 
   3.551531143702937*^9, 3.551531190790217*^9, 3.551531322489245*^9, 
   3.5515313846255417`*^9, 3.551533050280245*^9, 3.5515389037867403`*^9, {
   3.551538965135191*^9, 3.551538977205514*^9}, 3.551539108197977*^9, 
   3.551539201657524*^9, {3.551539253205459*^9, 3.551539275845779*^9}, 
   3.55153932027309*^9, 3.551539644637233*^9, 3.55154002191436*^9, 
   3.551540094807941*^9, 3.551540226644801*^9, 3.551540288264927*^9, {
   3.551540431699345*^9, 3.551540434289102*^9}, 3.551540725616721*^9, 
   3.5515408269125*^9, 3.55154260261994*^9, 3.551542640606536*^9, 
   3.551542718797987*^9, 3.5515442534301863`*^9, {3.551544300185874*^9, 
   3.5515443152644777`*^9}, 3.551545346563983*^9, {3.551545955670498*^9, 
   3.551545973968947*^9}, {3.55154652055713*^9, 3.551546529240282*^9}, 
   3.551546563611734*^9, 3.5515466042929583`*^9, 3.551717872410985*^9, 
   3.5517182538558283`*^9, 3.551718413739483*^9, 3.551718451918282*^9, 
   3.551718661115932*^9, 3.5517187270378036`*^9, 3.551718782706649*^9, 
   3.551718932334322*^9, 3.551718988904705*^9, 3.5517192515278683`*^9, 
   3.551719378139022*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Alpha", "/", 
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]"}], ")"}]}], "*", "360"}]], "Input",
 CellChangeTimes->{{3.551343272742961*^9, 3.551343283784504*^9}}],

Cell[BoxData["7.928141766202213`"], "Output",
 CellChangeTimes->{3.551718661164792*^9, 3.5517187270852947`*^9, 
  3.551718782828601*^9, 3.551718932435416*^9, 3.551718988938994*^9, 
  3.551719251624848*^9, 3.5517193781838703`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sAlpha", "=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"dNut", "*", "sl7"}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           SuperscriptBox["dNut", "2"], 
           RowBox[{"4", " ", 
            SuperscriptBox["l7", "2"]}]]}]], " ", 
        SuperscriptBox["l7", "2"]}]], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["sdNut", 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           SuperscriptBox["dNut", "2"], 
           RowBox[{"4", " ", 
            SuperscriptBox["l7", "2"]}]]}]], " ", "l7"}]], ")"}], 
     "2"]}]]}]], "Input",
 CellChangeTimes->{{3.551331907153528*^9, 3.55133192419549*^9}, {
  3.551331974843237*^9, 3.551331974899714*^9}, {3.551718623822852*^9, 
  3.5517186498566504`*^9}}],

Cell[BoxData["0.1392753714234643`"], "Output",
 CellChangeTimes->{{3.551331668094469*^9, 3.551331683254863*^9}, {
   3.5513318689358664`*^9, 3.55133187754425*^9}, {3.5513319287531033`*^9, 
   3.5513319427402983`*^9}, {3.5513319776581173`*^9, 3.551331979851313*^9}, 
   3.551332964238764*^9, 3.551333027982954*^9, {3.5513331361122417`*^9, 
   3.551333151204637*^9}, {3.551333185626133*^9, 3.551333202448485*^9}, {
   3.5513332463688593`*^9, 3.5513332728692007`*^9}, 3.551333334702857*^9, 
   3.551335562626231*^9, 3.5513360034620533`*^9, 3.5513360453909473`*^9, 
   3.551336079894606*^9, {3.5513361307211943`*^9, 3.5513362032625513`*^9}, {
   3.5513362402089567`*^9, 3.5513362649481773`*^9}, 3.551336353752433*^9, 
   3.551336643140737*^9, 3.55133670434479*^9, 3.5513368115057993`*^9, 
   3.551336843124592*^9, {3.551336880718748*^9, 3.5513369159323378`*^9}, 
   3.5513405245481653`*^9, 3.551342726169818*^9, {3.551343017430524*^9, 
   3.5513430636580467`*^9}, 3.5513431156850452`*^9, 3.5515284838790197`*^9, 
   3.551528526498025*^9, {3.551528775434732*^9, 3.5515287892998247`*^9}, 
   3.551528989649893*^9, 3.551529061780682*^9, 3.551529156278199*^9, 
   3.551529200068861*^9, 3.551529769403935*^9, 3.551531143775902*^9, 
   3.551531190860354*^9, 3.5515313227377253`*^9, 3.551531384707265*^9, 
   3.551533050513482*^9, 3.551538903885195*^9, {3.551538965276168*^9, 
   3.551538977313833*^9}, 3.5515391083220177`*^9, 3.551539201722341*^9, {
   3.551539253283205*^9, 3.551539275959661*^9}, 3.551539320427195*^9, 
   3.5515396447198877`*^9, 3.55154002199297*^9, 3.551540094954976*^9, 
   3.551540226745417*^9, 3.551540288347426*^9, {3.551540431777647*^9, 
   3.551540434529228*^9}, 3.551540725733448*^9, 3.5515408270710783`*^9, 
   3.551542602947893*^9, 3.551542640809669*^9, 3.5515427188667183`*^9, 
   3.5515442534995813`*^9, {3.551544300268725*^9, 3.551544315363309*^9}, 
   3.551545346828649*^9, {3.5515459560691338`*^9, 3.5515459742674437`*^9}, {
   3.55154652062311*^9, 3.551546529318771*^9}, 3.551546563677762*^9, 
   3.5515466043586197`*^9, 3.551717872508685*^9, 3.551718254183757*^9, 
   3.551718413804099*^9, 3.55171845201719*^9, {3.55171865087061*^9, 
   3.551718661212393*^9}, 3.551718727187133*^9, 3.551718782875195*^9, 
   3.5517189325712214`*^9, 3.551718988986618*^9, 3.551719251672138*^9, 
   3.5517193782384*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"dNut", "*", "sl7"}], 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           SuperscriptBox["dNut", "2"], 
           RowBox[{"4", " ", 
            SuperscriptBox["l7", "2"]}]]}]], " ", 
        SuperscriptBox["l7", "2"]}]], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["sdNut", 
       RowBox[{"2", " ", 
        SqrtBox[
         RowBox[{"1", "-", 
          FractionBox[
           SuperscriptBox["dNut", "2"], 
           RowBox[{"4", " ", 
            SuperscriptBox["l7", "2"]}]]}]], " ", "l7"}]], ")"}], "2"]}]], 
  "]"}]], "Input",
 CellChangeTimes->{{3.5517201295738564`*^9, 3.55172013286508*^9}}],

Cell[BoxData[
 SqrtBox[
  FractionBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["l7", "2"], " ", 
     SuperscriptBox["sdNut", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["dNut", "2"], " ", 
     SuperscriptBox["sl7", "2"]}]}], 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["dNut", "2"]}], " ", 
     SuperscriptBox["l7", "2"]}], "+", 
    RowBox[{"4", " ", 
     SuperscriptBox["l7", "4"]}]}]]]], "Output",
 CellChangeTimes->{3.551720133892033*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"sAlpha", "/", 
   RowBox[{"(", 
    RowBox[{"2", "\[Pi]"}], ")"}]}], "*", "360"}]], "Input",
 CellChangeTimes->{{3.551343288615473*^9, 3.551343294431835*^9}}],

Cell[BoxData["7.979890972681457`"], "Output",
 CellChangeTimes->{
  3.551343294757169*^9, 3.551528483925743*^9, 3.551528526533205*^9, {
   3.551528775488553*^9, 3.551528789366647*^9}, 3.551528989683887*^9, 
   3.551529061835498*^9, 3.5515291563116827`*^9, 3.551529200151301*^9, 
   3.5515297694366198`*^9, 3.551531143822934*^9, 3.551531190892795*^9, 
   3.551531322856825*^9, 3.551531384745163*^9, 3.551533050563138*^9, 
   3.5515389039354753`*^9, {3.55153896532831*^9, 3.5515389773879557`*^9}, 
   3.551539108370646*^9, 3.551539201758563*^9, {3.5515392533173637`*^9, 
   3.5515392760152607`*^9}, 3.551539320480876*^9, 3.551539644768773*^9, 
   3.55154002204401*^9, 3.5515400950031023`*^9, 3.551540226778624*^9, 
   3.551540288396206*^9, {3.5515404318302298`*^9, 3.5515404345669527`*^9}, 
   3.551540725867422*^9, 3.5515408271730757`*^9, 3.551542602985365*^9, 
   3.5515426408725348`*^9, 3.551542718931704*^9, 3.551544253545023*^9, {
   3.551544300302545*^9, 3.551544315419642*^9}, 3.551545346875268*^9, {
   3.5515459561134253`*^9, 3.551545974416937*^9}, {3.551546520656252*^9, 
   3.551546529355646*^9}, 3.551546563710382*^9, 3.551546604393038*^9, 
   3.551717872565194*^9, 3.551718254220642*^9, 3.551718413869027*^9, 
   3.551718452092846*^9, 3.551718661250531*^9, 3.55171872726423*^9, 
   3.551718782928344*^9, 3.55171893266967*^9, 3.551718989037581*^9, 
   3.551719251721334*^9, 3.5517193782878036`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K1", " ", "=", 
  RowBox[{"JFT", "/", "JPerp"}]}]], "Input",
 CellChangeTimes->{{3.551333369710514*^9, 3.551333376659931*^9}, {
   3.551541577106587*^9, 3.551541592498129*^9}, 3.551718400717338*^9}],

Cell[BoxData["0.16683817740439982`"], "Output",
 CellChangeTimes->{{3.551333370101672*^9, 3.55133337709173*^9}, 
   3.5513355626576*^9, 3.551336003509429*^9, 3.5513360454987297`*^9, 
   3.551336080011644*^9, {3.551336130751367*^9, 3.5513362033123283`*^9}, {
   3.55133624027354*^9, 3.5513362649975033`*^9}, 3.551336353802652*^9, 
   3.551336643186104*^9, 3.551336704443077*^9, 3.5513368116222887`*^9, 
   3.551336843257331*^9, {3.5513368807654657`*^9, 3.551336915966661*^9}, 
   3.551340524697763*^9, 3.551342546056697*^9, 3.5513427262156687`*^9, {
   3.551343017481139*^9, 3.551343063707418*^9}, 3.551343115729102*^9, 
   3.55152848402901*^9, 3.551528526565794*^9, {3.551528775533371*^9, 
   3.551528789401607*^9}, 3.5515289897160187`*^9, 3.551529061880517*^9, 
   3.5515291563786182`*^9, 3.551529200230843*^9, 3.55152976947044*^9, 
   3.551531143875251*^9, 3.551531190940898*^9, 3.5515313230930347`*^9, 
   3.5515313847912197`*^9, 3.5515330506139307`*^9, 3.551538903987857*^9, {
   3.551538965413834*^9, 3.551538977472569*^9}, 3.551539108421682*^9, 
   3.5515392017957087`*^9, {3.551539253369706*^9, 3.551539276052055*^9}, 
   3.551539320521679*^9, 3.551539644822094*^9, 3.5515400221481447`*^9, 
   3.551540095053688*^9, 3.551540226815662*^9, 3.5515402884480124`*^9, {
   3.551540431889106*^9, 3.551540434617868*^9}, 3.5515407259835157`*^9, 
   3.5515408272839622`*^9, {3.551541577839899*^9, 3.5515415933038807`*^9}, 
   3.551542603032754*^9, 3.551542640921555*^9, 3.551542718993499*^9, 
   3.5515442535967913`*^9, {3.551544300335865*^9, 3.551544315481923*^9}, 
   3.551545346927146*^9, {3.5515459561518383`*^9, 3.551545974541645*^9}, {
   3.551546520688921*^9, 3.551546529404626*^9}, 3.5515465637450323`*^9, 
   3.5515466044262543`*^9, 3.551717872610922*^9, 3.551718254266522*^9, {
   3.551718401249668*^9, 3.5517184139349422`*^9}, 3.551718452129858*^9, 
   3.551718661296463*^9, 3.5517187272979393`*^9, 3.551718782973686*^9, 
   3.5517189327668*^9, 3.551718989088357*^9, 3.551719251773717*^9, 
   3.551719378332572*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K1", "=", 
  FractionBox["JFT", 
   RowBox[{"JPerp", " ", 
    RowBox[{"Cos", "[", "Alpha", "]"}]}]]}]], "Input",
 CellChangeTimes->{{3.551031866871969*^9, 3.551031868651881*^9}, {
   3.551287300559664*^9, 3.551287301558694*^9}, {3.551331305578264*^9, 
   3.551331367656563*^9}, {3.551343156507326*^9, 3.5513431597639027`*^9}, 
   3.55154378329381*^9, {3.551718407035593*^9, 3.551718418522525*^9}}],

Cell[BoxData["0.168448233309577`"], "Output",
 CellChangeTimes->{
  3.55103186915307*^9, 3.5510320355327053`*^9, 3.5510322440057077`*^9, 
   3.551032283125806*^9, 3.551032772647828*^9, 3.551285085096005*^9, {
   3.551287011797518*^9, 3.551287032087181*^9}, 3.551287068186648*^9, 
   3.551287269748431*^9, 3.5512873022415123`*^9, 3.5512874465766373`*^9, 
   3.551330359155651*^9, {3.551330540249651*^9, 3.551330628670475*^9}, 
   3.551331310598032*^9, 3.551331420652876*^9, 3.5513316619530067`*^9, 
   3.551331869062645*^9, 3.551331942867996*^9, 3.5513319799018507`*^9, 
   3.5513329642879953`*^9, 3.551333028016037*^9, {3.551333136181005*^9, 
   3.551333151286478*^9}, {3.551333185908957*^9, 3.551333202482153*^9}, {
   3.55133324640203*^9, 3.551333272901925*^9}, 3.551333334753583*^9, 
   3.551335562691481*^9, 3.551336003548839*^9, 3.551336045553582*^9, 
   3.551336080123137*^9, {3.551336130784233*^9, 3.5513362033462753`*^9}, {
   3.5513362403434563`*^9, 3.551336265035795*^9}, 3.551336353852241*^9, 
   3.551336643241497*^9, 3.551336704644332*^9, 3.551336811726425*^9, 
   3.551336843406142*^9, {3.55133688081485*^9, 3.551336915999905*^9}, 
   3.551340524847219*^9, 3.551342547500751*^9, 3.551342726265402*^9, {
   3.551343017531287*^9, 3.55134306375696*^9}, 3.551343115767498*^9, 
   3.551528484179967*^9, 3.551528526598568*^9, {3.551528775636952*^9, 
   3.551528789432929*^9}, 3.5515289897503777`*^9, 3.551529061931117*^9, 
   3.551529156413454*^9, 3.551529200282124*^9, 3.5515297695044937`*^9, 
   3.5515311439113197`*^9, 3.551531190978319*^9, 3.551531323281644*^9, 
   3.55153138482202*^9, 3.5515330506499147`*^9, 3.551538904089333*^9, {
   3.5515389655475883`*^9, 3.551538977513109*^9}, 3.551539108470417*^9, 
   3.551539201841127*^9, {3.551539253481402*^9, 3.5515392760989532`*^9}, 
   3.5515393205993433`*^9, 3.551539644868701*^9, 3.551540022267047*^9, 
   3.551540095102993*^9, 3.551540226861006*^9, 3.5515402884793863`*^9, {
   3.5515404319266453`*^9, 3.55154043466818*^9}, 3.551540726083452*^9, 
   3.551540827387822*^9, 3.551542603065949*^9, 3.5515426409720497`*^9, 
   3.5515427190483227`*^9, 3.551543784030807*^9, 3.55154425364439*^9, {
   3.551544300367633*^9, 3.551544315529352*^9}, 3.5515453469884043`*^9, {
   3.551545956196479*^9, 3.551545974578236*^9}, {3.551546520722273*^9, 
   3.551546529439508*^9}, 3.551546563777845*^9, 3.551546604459379*^9, 
   3.551717872659354*^9, 3.5517182543033037`*^9, {3.5517184078912497`*^9, 
   3.5517184189507637`*^9}, 3.551718452178864*^9, 3.551718661347484*^9, 
   3.5517187273377523`*^9, 3.5517187830283546`*^9, 3.551718932866865*^9, 
   3.551718989136001*^9, 3.551719251823352*^9, 3.551719378383358*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sK1", "=", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"JPerp", " ", 
     RowBox[{"Cos", "[", "Alpha", "]"}]}]], 
   RowBox[{"\[Sqrt]", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"JFT", " ", "sJPerp"}], "JPerp"], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"JFT", " ", 
          RowBox[{"Sin", "[", "Alpha", "]"}], "*", "sAlpha"}], 
         RowBox[{"Cos", "[", "Alpha", "]"}]], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", "sJFT", ")"}], "2"]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5513428027534723`*^9, 3.551342802754998*^9}, {
  3.551343149157363*^9, 3.551343152558161*^9}, {3.551343604854473*^9, 
  3.5513436295292263`*^9}, {3.5513442648335*^9, 3.551344279302721*^9}, {
  3.551543795300535*^9, 3.5515438025481*^9}}],

Cell[BoxData["0.00732055120660641`"], "Output",
 CellChangeTimes->{
  3.551342803344902*^9, 3.551342952753387*^9, {3.551343017580943*^9, 
   3.551343063807893*^9}, {3.5513431158118153`*^9, 3.551343145051114*^9}, 
   3.551343633756789*^9, {3.551344268817398*^9, 3.551344280041154*^9}, 
   3.5515284842779818`*^9, 3.551528526630732*^9, {3.551528775750766*^9, 
   3.551528789465538*^9}, 3.5515289897832603`*^9, 3.551529061984809*^9, 
   3.551529156477072*^9, 3.551529200333248*^9, 3.551529769537339*^9, 
   3.551531143954302*^9, 3.5515311910092897`*^9, 3.551531323317196*^9, 
   3.551531384857173*^9, 3.5515330506958723`*^9, 3.551538904403843*^9, {
   3.5515389658178368`*^9, 3.551538977556871*^9}, 3.551539108520379*^9, 
   3.551539201876519*^9, {3.551539253619761*^9, 3.5515392761319017`*^9}, 
   3.55153932063028*^9, 3.551539644920438*^9, 3.551540022362705*^9, 
   3.551540095153335*^9, 3.5515402268938227`*^9, 3.5515402885324078`*^9, {
   3.55154043196233*^9, 3.5515404347183323`*^9}, 3.55154072628767*^9, 
   3.551540827449996*^9, 3.551542603098662*^9, 3.5515426410207453`*^9, 
   3.551542719129669*^9, 3.55154380317745*^9, 3.551544253695612*^9, {
   3.55154430045431*^9, 3.55154431558053*^9}, 3.551545347029752*^9, {
   3.551545956246793*^9, 3.5515459746274433`*^9}, {3.5515465207560253`*^9, 
   3.551546529486965*^9}, 3.551546563810424*^9, 3.551546604522923*^9, 
   3.551717872712247*^9, 3.5517182543487797`*^9, 3.5517184141352797`*^9, 
   3.551718452226927*^9, 3.551718661397204*^9, 3.5517187273842278`*^9, 
   3.551718783127891*^9, 3.551718932966391*^9, 3.551718989187093*^9, 
   3.55171925187171*^9, 3.551719378437626*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Diese Werte kommen aus gnuplot nutation.plot!", "Subsubtitle",
 CellChangeTimes->{{3.551332067732524*^9, 3.551332091480954*^9}, {
   3.551332572899197*^9, 3.551332575983498*^9}, 3.5513418764973793`*^9}],

Cell[CellGroupData[{

Cell[BoxData["K2"], "Input",
 CellChangeTimes->{{3.551332000680335*^9, 3.551332001689253*^9}, {
  3.5513320526682453`*^9, 3.551332055716433*^9}, {3.55133211513209*^9, 
  3.551332147803378*^9}, {3.5513334137597523`*^9, 3.551333414427534*^9}}],

Cell[BoxData["0.155104`"], "Output",
 CellChangeTimes->{3.551719251921462*^9, 3.551719378482736*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["0.155104"], "Input",
 CellChangeTimes->{{3.551719239512195*^9, 3.551719239534348*^9}}],

Cell[BoxData["0.155104`"], "Output",
 CellChangeTimes->{{3.5517192412944317`*^9, 3.551719251969768*^9}, 
   3.551719378532586*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["sK2"], "Input",
 CellChangeTimes->{{3.551333415616527*^9, 3.551333416866413*^9}}],

Cell[BoxData["0.002912`"], "Output",
 CellChangeTimes->{
  3.5513334172914553`*^9, 3.551335562790289*^9, 3.5513360036943417`*^9, 
   3.5513360456537046`*^9, 3.5513360802777977`*^9, {3.551336130986957*^9, 
   3.551336203445777*^9}, {3.55133624060918*^9, 3.551336265237402*^9}, 
   3.551336353983767*^9, 3.551336643538834*^9, 3.551336704920898*^9, 
   3.5513368120229263`*^9, 3.551336843569068*^9, {3.551336880948814*^9, 
   3.551336916171226*^9}, 3.551340525041192*^9, 3.551342726431737*^9, {
   3.551343017680578*^9, 3.551343063905945*^9}, 3.551343115912017*^9, 
   3.551528484373549*^9, 3.551528526697283*^9, {3.551528775932672*^9, 
   3.55152878953165*^9}, 3.5515289898492537`*^9, 3.5515290620665493`*^9, 
   3.551529156698604*^9, 3.551529200431389*^9, 3.551529769602895*^9, 
   3.551531144055854*^9, 3.551531191096328*^9, 3.551531323420375*^9, 
   3.5515313849382563`*^9, 3.551533050795404*^9, 3.551538904516403*^9, {
   3.5515389659655046`*^9, 3.551538977660039*^9}, 3.551539108620626*^9, 
   3.5515392023912163`*^9, {3.551539253961347*^9, 3.551539276230721*^9}, 
   3.551539320845517*^9, 3.551539645036318*^9, 3.55154002249327*^9, 
   3.551540095302779*^9, 3.551540227215107*^9, 3.5515402886637783`*^9, {
   3.551540432109671*^9, 3.551540434849271*^9}, 3.551540726441655*^9, 
   3.551540827598591*^9, 3.551542603283616*^9, 3.551542641122748*^9, 
   3.551542719312305*^9, 3.5515442538656197`*^9, {3.5515443006419086`*^9, 
   3.55154431567975*^9}, 3.5515453471069307`*^9, {3.551545956345726*^9, 
   3.551545974727586*^9}, {3.551546520819796*^9, 3.551546529555379*^9}, 
   3.551546563877453*^9, 3.551546604660549*^9, 3.551717872857666*^9, 
   3.5517182544312057`*^9, 3.551718414256102*^9, 3.551718452375943*^9, 
   3.551718661478088*^9, 3.55171872746874*^9, 3.551718783271905*^9, 
   3.551718933111711*^9, 3.551718989272707*^9, 3.551719252007539*^9, 
   3.5517193785816402`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Relative Abweichungen:", "Subsubtitle",
 CellChangeTimes->{{3.551332588188795*^9, 3.5513325968343363`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"(", 
     RowBox[{"K1", "/", "K2"}], ")"}]}], ")"}], "*", "100"}]], "Input",
 CellChangeTimes->{{3.5513325999113607`*^9, 3.5513326870901213`*^9}, {
  3.551719683222863*^9, 3.551719684118499*^9}}],

Cell[BoxData["8.603410169677783`"], "Output",
 CellChangeTimes->{{3.551332611018045*^9, 3.551332687464587*^9}, 
   3.551332964434539*^9, 3.551333028150075*^9, {3.551333136291794*^9, 
   3.551333151557295*^9}, {3.551333186039641*^9, 3.551333202577703*^9}, {
   3.551333246668195*^9, 3.551333272998321*^9}, 3.551333334882534*^9, 
   3.551335562824133*^9, 3.5513360037444077`*^9, 3.551336045685458*^9, 
   3.5513360803066273`*^9, {3.551336131121098*^9, 3.551336203494563*^9}, {
   3.551336240690727*^9, 3.551336265384297*^9}, 3.551336354033559*^9, 
   3.551336643638013*^9, 3.551336704957409*^9, 3.55133681207666*^9, 
   3.551336843608819*^9, {3.551336880998391*^9, 3.551336916285101*^9}, 
   3.551340525076291*^9, 3.551342726465341*^9, {3.551343017729065*^9, 
   3.551343063956056*^9}, 3.551343115948532*^9, 3.551528484426866*^9, 
   3.551528526769021*^9, {3.551528775982503*^9, 3.551528789569672*^9}, 
   3.5515289898831673`*^9, 3.55152906211339*^9, 3.5515291567992992`*^9, 
   3.551529200479512*^9, 3.551529769636043*^9, 3.551531144105557*^9, 
   3.55153119114565*^9, 3.551531323536585*^9, 3.551531384996784*^9, 
   3.551533050843899*^9, 3.5515389045969763`*^9, {3.5515389660575113`*^9, 
   3.551538977711639*^9}, 3.55153910870044*^9, 3.551539202540362*^9, {
   3.5515392540171223`*^9, 3.5515392762642736`*^9}, 3.551539320906518*^9, 
   3.551539645068103*^9, 3.551540022540183*^9, 3.5515400953515387`*^9, 
   3.551540227352577*^9, 3.551540288715027*^9, {3.5515404321602373`*^9, 
   3.551540434901964*^9}, 3.5515407264953136`*^9, 3.5515408276480207`*^9, 
   3.551542603415552*^9, 3.551542641173953*^9, 3.551542719549088*^9, 
   3.551544254014835*^9, {3.551544300791091*^9, 3.551544315727798*^9}, 
   3.551545347157744*^9, {3.551545956383709*^9, 3.551545974775956*^9}, {
   3.5515465208539753`*^9, 3.551546529588682*^9}, 3.551546563909555*^9, 
   3.551546604694449*^9, 3.55154704150476*^9, 3.5517178729115868`*^9, 
   3.551718254468851*^9, 3.551718414304093*^9, 3.551718452411199*^9, 
   3.551718661533457*^9, 3.551718727513056*^9, 3.551718783310902*^9, 
   3.551718933151601*^9, 3.551718989303376*^9, 3.551719252038842*^9, 
   3.5517193786366663`*^9, 3.551719684554173*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K1", "-", "sK1"}]], "Input",
 CellChangeTimes->{{3.551544594501734*^9, 3.551544597577364*^9}}],

Cell[BoxData["0.1611276821029706`"], "Output",
 CellChangeTimes->{
  3.5515445979039297`*^9, 3.551545347242619*^9, {3.551545956615468*^9, 
   3.551545974827511*^9}, {3.5515465208862743`*^9, 3.551546529623543*^9}, 
   3.551546563943657*^9, 3.551546604793804*^9, 3.551547043879464*^9, 
   3.551717872959776*^9, 3.5517182545516787`*^9, 3.5517184143543777`*^9, 
   3.5517184524460707`*^9, 3.55171866157656*^9, 3.55171872755343*^9, 
   3.551718783355485*^9, 3.551718933197629*^9, 3.5517189893514347`*^9, 
   3.551719252293997*^9, 3.551719378686331*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"K1", "+", "sK1"}]], "Input",
 CellChangeTimes->{{3.5515445983539877`*^9, 3.5515446002830887`*^9}}],

Cell[BoxData["0.1757687845161834`"], "Output",
 CellChangeTimes->{
  3.551544600858203*^9, 3.5515453473436527`*^9, {3.551545956715908*^9, 
   3.551545974876834*^9}, {3.5515465209357433`*^9, 3.551546529655019*^9}, 
   3.55154656397677*^9, 3.5515466048930902`*^9, 3.551717873193277*^9, 
   3.551718254682761*^9, 3.5517184144343243`*^9, 3.5517184525471287`*^9, 
   3.55171866167866*^9, 3.551718727649671*^9, 3.5517187834543962`*^9, 
   3.551718933300037*^9, 3.5517189893899612`*^9, 3.5517192524400578`*^9, 
   3.5517193787315063`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    RowBox[{"JFPr1", "/", "JF"}]}], ")"}], "*", "100"}]], "Input",
 CellChangeTimes->{{3.5517196482052927`*^9, 3.5517196923030577`*^9}}],

Cell[BoxData["8.66910717477667`"], "Output",
 CellChangeTimes->{{3.551719661523641*^9, 3.55171969313774*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["JFPr1"], "Input",
 CellChangeTimes->{{3.551719708181727*^9, 3.551719710277939*^9}}],

Cell[BoxData["0.011187336439650222`"], "Output",
 CellChangeTimes->{3.551719711337172*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["JF"], "Input",
 CellChangeTimes->{{3.551719714509192*^9, 3.551719714640297*^9}}],

Cell[BoxData["0.010294863674233747`"], "Output",
 CellChangeTimes->{3.5517197151077957`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JF", "/", "JFPr1"}]], "Input",
 CellChangeTimes->{{3.551719723160327*^9, 3.5517197258025084`*^9}}],

Cell[BoxData["0.9202247317553293`"], "Output",
 CellChangeTimes->{3.551719726331085*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{955, 652},
WindowMargins->{{Automatic, -235}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 124, 1, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[728, 27, 1893, 34, 223, "Input"],
Cell[2624, 63, 1124, 16, 27, "Output"],
Cell[3751, 81, 1111, 16, 27, "Output"],
Cell[4865, 99, 1111, 16, 27, "Output"],
Cell[5979, 117, 1113, 16, 27, "Output"],
Cell[7095, 135, 1125, 16, 27, "Output"],
Cell[8223, 153, 1110, 16, 27, "Output"]
}, Open  ]],
Cell[9348, 172, 935, 14, 103, "Input"],
Cell[10286, 188, 1132, 19, 133, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11455, 212, 129, 1, 26, "Subsubtitle"],
Cell[11587, 215, 894, 22, 73, "Input"],
Cell[12484, 239, 124, 2, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12645, 246, 141, 1, 26, "Subsubtitle"],
Cell[12789, 249, 1095, 20, 163, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13921, 274, 176, 2, 26, "Subsubtitle"],
Cell[14100, 278, 751, 11, 73, "Input"],
Cell[CellGroupData[{
Cell[14876, 293, 291, 6, 47, "Input"],
Cell[15170, 301, 2320, 32, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17527, 338, 423, 9, 66, "Input"],
Cell[17953, 349, 2307, 32, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20297, 386, 277, 6, 46, "Input"],
Cell[20577, 394, 2385, 33, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22999, 432, 469, 14, 66, "Input"],
Cell[23471, 448, 2367, 33, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25875, 486, 474, 14, 52, "Input"],
Cell[26352, 502, 2674, 37, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29063, 544, 1314, 38, 53, "Input"],
Cell[30380, 584, 2515, 35, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32932, 624, 473, 14, 52, "Input"],
Cell[33408, 640, 189, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[33634, 647, 1276, 39, 53, "Input"],
Cell[34913, 688, 2402, 34, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[37352, 727, 530, 15, 52, "Input"],
Cell[37885, 744, 2711, 38, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40633, 787, 1220, 37, 53, "Input"],
Cell[41856, 826, 2408, 34, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44301, 865, 216, 5, 27, "Input"],
Cell[44520, 872, 2705, 38, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47262, 915, 321, 8, 39, "Input"],
Cell[47586, 925, 2330, 33, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[49965, 964, 155, 2, 46, "Subtitle"],
Cell[50123, 968, 158, 3, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[50306, 975, 606, 16, 51, "Input"],
Cell[50915, 993, 2385, 33, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53337, 1031, 1112, 34, 53, "Input"],
Cell[54452, 1067, 2258, 32, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56747, 1104, 143, 1, 34, "Subsubtitle"],
Cell[CellGroupData[{
Cell[56915, 1109, 191, 4, 46, "Input"],
Cell[57109, 1115, 697, 10, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[57843, 1130, 677, 20, 52, "Input"],
Cell[58523, 1152, 2035, 28, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60595, 1185, 190, 4, 46, "Input"],
Cell[60788, 1191, 1953, 27, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[62778, 1223, 675, 20, 52, "Input"],
Cell[63456, 1245, 1895, 27, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[65388, 1277, 237, 5, 47, "Input"],
Cell[65628, 1284, 1949, 27, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[67614, 1316, 622, 19, 65, "Input"],
Cell[68239, 1337, 1898, 27, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70198, 1371, 114, 1, 46, "Subtitle"],
Cell[CellGroupData[{
Cell[70337, 1376, 1078, 30, 48, "Input"],
Cell[71418, 1408, 1722, 24, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73177, 1437, 593, 17, 65, "Input"],
Cell[73773, 1456, 1687, 23, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[75497, 1484, 205, 2, 59, "Subsubtitle"],
Cell[CellGroupData[{
Cell[75727, 1490, 403, 8, 46, "Input"],
Cell[76133, 1500, 2228, 31, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78398, 1536, 192, 5, 27, "Input"],
Cell[78593, 1543, 229, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[78859, 1551, 920, 29, 106, "Input"],
Cell[79782, 1582, 2326, 32, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[82145, 1619, 826, 27, 106, "Input"],
Cell[82974, 1648, 476, 17, 65, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83487, 1670, 193, 5, 27, "Input"],
Cell[83683, 1677, 1408, 20, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[85128, 1702, 222, 4, 27, "Input"],
Cell[85353, 1708, 2023, 28, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[87413, 1741, 422, 8, 48, "Input"],
Cell[87838, 1751, 2663, 37, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[90538, 1793, 898, 24, 52, "Input"],
Cell[91439, 1819, 1629, 23, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[93117, 1848, 208, 2, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[93350, 1854, 241, 3, 27, "Input"],
Cell[93594, 1859, 100, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[93731, 1865, 100, 1, 27, "Input"],
Cell[93834, 1868, 130, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[94001, 1875, 95, 1, 27, "Input"],
Cell[94099, 1878, 1880, 27, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[96028, 1911, 113, 1, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[96166, 1916, 290, 8, 27, "Input"],
Cell[96459, 1926, 2172, 30, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98668, 1961, 118, 2, 27, "Input"],
Cell[98789, 1965, 547, 8, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[99373, 1978, 122, 2, 27, "Input"],
Cell[99498, 1982, 531, 8, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100066, 1995, 218, 6, 27, "Input"],
Cell[100287, 2003, 109, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100433, 2009, 97, 1, 27, "Input"],
Cell[100533, 2012, 90, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100660, 2018, 94, 1, 27, "Input"],
Cell[100757, 2021, 92, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100886, 2027, 122, 2, 27, "Input"],
Cell[101011, 2031, 88, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
