(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     28684,        748]
NotebookOptionsPosition[     25950,        645]
NotebookOutlinePosition[     26307,        661]
CellTagsIndexPosition[     26264,        658]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"CPlatt", " ", "=", " ", 
  RowBox[{"4.0008", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "09"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5582669954802723`*^9, 3.558267000987934*^9}, {
  3.558267036244492*^9, 3.558267040060261*^9}, {3.558267988383301*^9, 
  3.558268013026196*^9}, {3.558268683877942*^9, 3.5582686917577543`*^9}, {
  3.55826968872418*^9, 3.5582696909694843`*^9}, {3.558269723762971*^9, 
  3.558269758015801*^9}, {3.558269869110436*^9, 3.5582698749081078`*^9}, {
  3.558270197421067*^9, 3.558270197771204*^9}, {3.55835731130974*^9, 
  3.558357340604207*^9}}],

Cell[BoxData["4.0008000000000005`*^-9"], "Output",
 CellChangeTimes->{
  3.558267007646681*^9, 3.558267040432227*^9, 3.558267536929837*^9, 
   3.558267569042184*^9, 3.558267821648368*^9, {3.558267868506502*^9, 
   3.558267873090365*^9}, {3.558267990500121*^9, 3.5582680144765043`*^9}, {
   3.558268552765563*^9, 3.5582685609853477`*^9}, {3.558268687063306*^9, 
   3.558268693091309*^9}, {3.5582690453459787`*^9, 3.558269049874312*^9}, 
   3.558269292382635*^9, {3.558269691941331*^9, 3.5582697022698298`*^9}, {
   3.558269752766406*^9, 3.558269761513946*^9}, {3.5582698708404217`*^9, 
   3.558269876203288*^9}, {3.558269970352046*^9, 3.5582699747673693`*^9}, 
   3.558270206285413*^9, 3.558270296366351*^9, {3.55835732972244*^9, 
   3.5583573414415092`*^9}, 3.558357450719981*^9, 3.5583575052264957`*^9, 
   3.558358121010034*^9, 3.5583583861194487`*^9, 3.5583584623953753`*^9, 
   3.5583588498419237`*^9, {3.558359104468252*^9, 3.55835913302771*^9}, 
   3.5583698637016687`*^9, 3.55843568510529*^9, 3.5585087947710876`*^9, 
   3.5588487576449833`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sCPlatt", " ", "=", " ", 
  RowBox[{"1.38", "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "10"}]}]}]}]], "Input",
 CellChangeTimes->{{3.558357344543347*^9, 3.558357361243754*^9}}],

Cell[BoxData["1.38`*^-10"], "Output",
 CellChangeTimes->{
  3.558357361983369*^9, 3.558357450793434*^9, 3.558357505279871*^9, 
   3.558358121092759*^9, 3.55835838617732*^9, 3.558358462491086*^9, 
   3.558358849919441*^9, {3.558359104551509*^9, 3.558359133110818*^9}, 
   3.5583698637816753`*^9, 3.558435685231719*^9, 3.558508794913789*^9, 
   3.5588487577821293`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LAMBDA1", " ", "=", " ", 
  RowBox[{
   RowBox[{"1", "/", "361.418181595329"}], "*", "54.10"}]}]], "Input",
 CellChangeTimes->{{3.558267051191921*^9, 3.558267055666704*^9}, {
   3.558267087654269*^9, 3.5582670995383253`*^9}, 3.5582675345026913`*^9, 
   3.558357435533449*^9, {3.5583574820798197`*^9, 3.5583574881996727`*^9}, {
   3.558358010475499*^9, 3.558358010784884*^9}, {3.5583581117898273`*^9, 
   3.558358112085765*^9}, {3.558358310984866*^9, 3.558358312408141*^9}, {
   3.558358363719274*^9, 3.558358380294482*^9}, {3.558358544995153*^9, 
   3.558358552281649*^9}, {3.558358683142331*^9, 3.55835868698986*^9}}],

Cell[BoxData["0.14968809748640272`"], "Output",
 CellChangeTimes->{
  3.558267100693667*^9, {3.558267535534403*^9, 3.5582675369953814`*^9}, 
   3.558267569107999*^9, 3.558267821713449*^9, {3.558267868571286*^9, 
   3.558267873154681*^9}, 3.5582680145105*^9, {3.558268552865324*^9, 
   3.558268561050068*^9}, {3.558268687130581*^9, 3.558268693156739*^9}, {
   3.558269045424427*^9, 3.558269049957911*^9}, 3.558269292451311*^9, 
   3.558269702336481*^9, 3.5582697615809803`*^9, {3.558269870906623*^9, 
   3.558269876286677*^9}, {3.5582699704338093`*^9, 3.5582699748499947`*^9}, 
   3.558270206353114*^9, 3.558270296415991*^9, {3.558357437446741*^9, 
   3.558357450876329*^9}, {3.558357488540147*^9, 3.5583575053303957`*^9}, 
   3.5583580118173933`*^9, {3.558358119050666*^9, 3.558358121149839*^9}, 
   3.55835831292554*^9, {3.558358364997864*^9, 3.5583583862222443`*^9}, 
   3.558358462537945*^9, {3.558358548495577*^9, 3.558358552746153*^9}, 
   3.558358687392531*^9, 3.558358849975868*^9, {3.558359104608552*^9, 
   3.558359133168248*^9}, 3.558369863821575*^9, 3.558435685274681*^9, 
   3.558508794952916*^9, 3.5588487578367033`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sLAMBDA1", " ", "=", " ", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{"1.78469497261536", "/", 
        RowBox[{"361.418181595329", "^", "2"}]}], "*", "54.10"}], ")"}], "^", 
     "2"}], "+", 
    RowBox[{
     RowBox[{"(", " ", 
      RowBox[{
       RowBox[{"1", "/", "361.418181595329"}], "*", "0.1"}], ")"}], "^", 
     "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5583575275428267`*^9, 3.5583575428866*^9}, {
  3.5583580183446712`*^9, 3.5583580186483517`*^9}, {3.558358115597884*^9, 
  3.558358115893592*^9}, {3.5583583269107103`*^9, 3.558358337695756*^9}, {
  3.5583586933742533`*^9, 3.558358694085886*^9}, {3.558358813250259*^9, 
  3.558358845722402*^9}}],

Cell[BoxData["0.0007892532712115997`"], "Output",
 CellChangeTimes->{
  3.55835754381782*^9, 3.5583580196215754`*^9, {3.55835811745688*^9, 
   3.558358121194448*^9}, {3.558358330278038*^9, 3.558358338117386*^9}, 
   3.55835838627064*^9, 3.558358462618353*^9, {3.558358847494783*^9, 
   3.5583588500260563`*^9}, {3.558359104658589*^9, 3.5583591332185907`*^9}, 
   3.558369863879559*^9, 3.558435685320628*^9, 3.5585087950021753`*^9, 
   3.558848757884368*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T1", " ", "=", " ", 
  RowBox[{"54.1", "/", "1000000"}]}]], "Input",
 CellChangeTimes->{{3.5582671025494337`*^9, 3.558267130625339*^9}, {
   3.5582675560538797`*^9, 3.558267564469322*^9}, {3.5582678664856358`*^9, 
   3.558267871180601*^9}, {3.558270172436064*^9, 3.558270172843732*^9}, 
   3.5583574191568823`*^9, {3.558357491392069*^9, 3.558357492735867*^9}}],

Cell[BoxData["0.0000541`"], "Output",
 CellChangeTimes->{
  3.5582671310449553`*^9, {3.558267537028338*^9, 3.558267569141361*^9}, 
   3.558267821747794*^9, {3.558267867343289*^9, 3.5582678731882277`*^9}, 
   3.558268014543284*^9, {3.558268552902666*^9, 3.55826856108876*^9}, {
   3.558268687164159*^9, 3.558268693194489*^9}, {3.5582690454630537`*^9, 
   3.558269049995344*^9}, 3.558269292489665*^9, 3.5582697023696337`*^9, 
   3.5582697616179733`*^9, {3.558269870938623*^9, 3.5582698763240757`*^9}, {
   3.558269970466877*^9, 3.558269974889784*^9}, 3.558270206386764*^9, 
   3.5582702964821177`*^9, {3.558357438361474*^9, 3.5583574509394417`*^9}, {
   3.55835749340646*^9, 3.5583575053805723`*^9}, 3.5583581212759867`*^9, 
   3.5583583404397182`*^9, 3.558358386321721*^9, 3.558358462679063*^9, 
   3.558358850071082*^9, {3.558359104734811*^9, 3.5583591332932787`*^9}, 
   3.55836986394063*^9, 3.5584356853822603`*^9, 3.5585087950509453`*^9, 
   3.558848757934804*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sT1", " ", "=", " ", 
  RowBox[{"0.1", "/", "1000000"}]}]], "Input",
 CellChangeTimes->{{3.55835754677031*^9, 3.55835755322165*^9}}],

Cell[BoxData["1.`*^-7"], "Output",
 CellChangeTimes->{
  3.558357553894505*^9, 3.5583581213386583`*^9, 3.558358386370947*^9, 
   3.558358462739758*^9, 3.5583588501681767`*^9, {3.5583591047867947`*^9, 
   3.558359133346767*^9}, 3.558369863990561*^9, 3.558435685419342*^9, 
   3.5585087951462917`*^9, 3.5588487579845877`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LAMBDA2", " ", "=", " ", 
  RowBox[{
   RowBox[{"1", "/", "4.01578696789016"}], "*", 
   "1.43382352941176"}]}]], "Input",
 CellChangeTimes->{{3.558268050291604*^9, 3.5582680520711603`*^9}, 
   3.558268102725197*^9, {3.558357448307325*^9, 3.558357448682273*^9}, {
   3.5583575004393597`*^9, 3.558357501039083*^9}, {3.558358068281207*^9, 
   3.55835808953467*^9}, {3.5583584374931087`*^9, 3.55835844908469*^9}, {
   3.558358746127491*^9, 3.558358750924453*^9}}],

Cell[BoxData["0.35704671111203673`"], "Output",
 CellChangeTimes->{
  3.5582681032948*^9, {3.558268552949134*^9, 3.558268561134365*^9}, {
   3.558268687197489*^9, 3.558268693240528*^9}, {3.558269045508984*^9, 
   3.558269050042018*^9}, 3.558269292534959*^9, 3.5582697024067373`*^9, 
   3.5582697616644077`*^9, {3.558269870975013*^9, 3.558269876369198*^9}, {
   3.558269970503467*^9, 3.558269974934703*^9}, 3.5582702064191437`*^9, 
   3.558270296515217*^9, {3.558357449337913*^9, 3.558357450973172*^9}, {
   3.55835750150954*^9, 3.558357505433839*^9}, {3.558358070762988*^9, 
   3.558358121400885*^9}, 3.558358386452017*^9, {3.558358449398715*^9, 
   3.558358462790066*^9}, 3.5583587517517967`*^9, 3.55835885022302*^9, {
   3.5583591048374434`*^9, 3.5583591333971663`*^9}, 3.558369864046946*^9, 
   3.558435685458454*^9, 3.558508795188559*^9, 3.558848758036525*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sLAMBDA2", " ", "=", " ", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0.175386270547065", "/", 
        RowBox[{"4.01578696789016", "^", "2"}]}], "*", "1.43382352941176"}], 
      ")"}], "^", "2"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", "4.01578696789016"}], "*", "0.05"}], ")"}], "^", 
     "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.558357555935952*^9, 3.5583575720858507`*^9}, {
  3.558358091488418*^9, 3.5583580946224127`*^9}, {3.558358451516789*^9, 
  3.558358456420196*^9}, {3.558358759250567*^9, 3.558358805043427*^9}}],

Cell[BoxData["0.019954655352632196`"], "Output",
 CellChangeTimes->{
  3.55835757287506*^9, {3.5583580955873423`*^9, 3.558358121460837*^9}, 
   3.5583583865349493`*^9, {3.558358457086475*^9, 3.558358462834642*^9}, 
   3.5583588068138247`*^9, 3.558358850271534*^9, {3.558359104886902*^9, 
   3.558359133449347*^9}, 3.558369864106358*^9, 3.5584356855026083`*^9, 
   3.5585087952375526`*^9, 3.558848758088916*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"T2", " ", "=", " ", 
  RowBox[{"1.43382352941176", "/", "1000"}]}]], "Input",
 CellChangeTimes->{{3.558268111844515*^9, 3.5582681249895563`*^9}, {
   3.558270205395208*^9, 3.558270205506811*^9}, 3.5583574225380173`*^9, {
   3.558357473496217*^9, 3.558357504223159*^9}}],

Cell[BoxData["0.0014338235294117602`"], "Output",
 CellChangeTimes->{
  3.5582681254781017`*^9, {3.5582685529819117`*^9, 3.558268561167861*^9}, {
   3.558268687230502*^9, 3.558268693274248*^9}, {3.558269045540732*^9, 
   3.5582690500744123`*^9}, 3.558269292568643*^9, 3.558269702452944*^9, 
   3.5582697616988087`*^9, {3.558269871022999*^9, 3.558269876420568*^9}, {
   3.5582699705506887`*^9, 3.558269974983842*^9}, 3.558270206484548*^9, 
   3.558270296582192*^9, {3.55835744998556*^9, 3.5583574510796137`*^9}, {
   3.558357504580614*^9, 3.5583575055268087`*^9}, 3.558358121515554*^9, 
   3.558358386591819*^9, {3.55835845841566*^9, 3.55835846288536*^9}, 
   3.55835885031981*^9, {3.558359104940865*^9, 3.558359133501718*^9}, 
   3.5583698641529713`*^9, 3.558435685551516*^9, 3.5585087952871647`*^9, 
   3.5588487581843843`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sT2", " ", "=", " ", 
  RowBox[{"0.05", " ", "/", "1000"}]}]], "Input",
 CellChangeTimes->{{3.558357577089896*^9, 3.558357585836673*^9}}],

Cell[BoxData["0.00005`"], "Output",
 CellChangeTimes->{
  3.55835758654143*^9, 3.558358121559538*^9, 3.558358386637253*^9, {
   3.55835845934545*^9, 3.558358462934963*^9}, 3.55835885037033*^9, {
   3.5583591050108643`*^9, 3.5583591335537777`*^9}, 3.5583698642024727`*^9, 
   3.558435685603568*^9, 3.558508795337119*^9, 3.558848758255268*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Induktivit\[ADoubleDot]t/Widerstand der Luftspule\
\>", "Subsubtitle",
 CellChangeTimes->{{3.558508736110071*^9, 3.558508748702693*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"L1", " ", "=", " ", 
  RowBox[{
   FractionBox["1", "CPlatt"], 
   FractionBox[
    RowBox[{"T1", "^", "2"}], 
    RowBox[{
     RowBox[{"4", 
      RowBox[{"\[Pi]", "^", "2"}]}], "+", 
     RowBox[{"LAMBDA1", "^", "2"}]}]]}]}]], "Input",
 CellChangeTimes->{{3.5582671366884727`*^9, 3.55826717429664*^9}, {
  3.5582695212788343`*^9, 3.558269521910668*^9}, {3.558269693546283*^9, 
  3.558269694081979*^9}, {3.558269968643961*^9, 3.5582699735619698`*^9}, {
  3.558270092527403*^9, 3.558270093486596*^9}, {3.5582702903214483`*^9, 
  3.5582702908890657`*^9}}],

Cell[BoxData["0.018520023438959806`"], "Output",
 CellChangeTimes->{
  3.5582671752633343`*^9, {3.5582675370614758`*^9, 3.5582675691744967`*^9}, {
   3.558267817065284*^9, 3.558267821780553*^9}, {3.558267868638318*^9, 
   3.558267873221241*^9}, 3.5582680145777397`*^9, {3.558268553046631*^9, 
   3.55826856120443*^9}, {3.558268687263913*^9, 3.5582686933104553`*^9}, {
   3.558269045606482*^9, 3.55826905010787*^9}, 3.5582692926343393`*^9, 
   3.55826952232434*^9, 3.5582697025025167`*^9, 3.5582697617324877`*^9, {
   3.5582698710568237`*^9, 3.55826987646952*^9}, {3.5582699706166277`*^9, 
   3.5582699750344353`*^9}, 3.5582700942362127`*^9, 3.55827020652255*^9, {
   3.5582702628909817`*^9, 3.558270296632015*^9}, 3.558357451180773*^9, {
   3.5583574951837997`*^9, 3.558357505581685*^9}, 3.558358121608877*^9, {
   3.558358343710959*^9, 3.5583583866862307`*^9}, 3.558358462983837*^9, 
   3.5583588504197617`*^9, {3.558359105069488*^9, 3.5583591336125917`*^9}, 
   3.558369864251648*^9, 3.55843568564006*^9, 3.5585087953865213`*^9, 
   3.558848758302401*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sL1", " ", "=", " ", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "CPlatt"], 
       FractionBox[
        RowBox[{"2", "*", "T1", "*", "sT1"}], 
        RowBox[{
         RowBox[{"4", 
          RowBox[{"\[Pi]", "^", "2"}]}], "+", 
         RowBox[{"LAMBDA1", "^", "2"}]}]]}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["sCPlatt", 
        RowBox[{"CPlatt", "^", "2"}]], 
       FractionBox[
        RowBox[{"T1", "^", "2"}], 
        RowBox[{
         RowBox[{"4", 
          RowBox[{"\[Pi]", "^", "2"}]}], "+", 
         RowBox[{"LAMBDA1", "^", "2"}]}]]}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "CPlatt"], 
       FractionBox[
        RowBox[{
         RowBox[{"T1", "^", "2"}], "*", "2", "*", "LAMBDA1", "*", 
         "sLAMBDA1"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{"\[Pi]", "^", "2"}]}], "+", 
           RowBox[{"LAMBDA1", "^", "2"}]}], ")"}], "^", "2"}]]}], ")"}], "^", 
     "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.558357594508915*^9, 3.558357720326077*^9}}],

Cell[BoxData["0.0006424715544276765`"], "Output",
 CellChangeTimes->{
  3.558357723993462*^9, 3.558358121694016*^9, 3.558358386736589*^9, 
   3.5583584630388193`*^9, 3.558358850469366*^9, {3.5583591051241713`*^9, 
   3.558359133684042*^9}, 3.558369864301396*^9, 3.558435685685761*^9, 
   3.558508795436067*^9, 3.558848758350113*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RL1", " ", "=", " ", 
  RowBox[{
   RowBox[{"LAMBDA1", "/", "T1"}], " ", "*", " ", "2", "*", "L1"}]}]], "Input",\

 CellChangeTimes->{{3.558267223514985*^9, 3.558267250054019*^9}}],

Cell[BoxData["102.48528924145947`"], "Output",
 CellChangeTimes->{
  3.5582672506313868`*^9, 3.558267537094245*^9, 3.558267569207149*^9, 
   3.558267821813014*^9, {3.558267868670809*^9, 3.558267873253387*^9}, 
   3.558268014642167*^9, {3.5582685530878687`*^9, 3.5582685612510033`*^9}, {
   3.558268687296829*^9, 3.558268693372775*^9}, {3.5582690456442127`*^9, 
   3.558269050141077*^9}, 3.558269292668397*^9, 3.55826970253547*^9, 
   3.5582697617651587`*^9, {3.558269871105382*^9, 3.5582698765358267`*^9}, {
   3.5582699706540823`*^9, 3.558269975083434*^9}, 3.558270206556682*^9, 
   3.558270296663641*^9, 3.558357451239089*^9, 3.558357505650676*^9, 
   3.55835812174824*^9, 3.558358386785461*^9, 3.5583584630887213`*^9, 
   3.558358850521411*^9, {3.558359105171945*^9, 3.558359133732482*^9}, 
   3.558369864350539*^9, 3.558435685734848*^9, 3.5585087954835033`*^9, 
   3.558848758401671*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sRL1", " ", "=", " ", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sLAMBDA1", "/", "T1"}], " ", "*", " ", "2", "*", "L1"}], 
      ")"}], "^", "2"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"LAMBDA1", "/", "T1"}], " ", "*", " ", "2", "*", "sL1"}], 
      ")"}], "^", "2"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"LAMBDA1", "*", 
       RowBox[{"sT1", "/", 
        RowBox[{"T1", "^", "2"}]}], " ", "*", " ", "2", "*", "L1"}], ")"}], 
     "^", "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.558358927378518*^9, 3.558358973327676*^9}}],

Cell[BoxData["3.601097966013245`"], "Output",
 CellChangeTimes->{{3.5583589550418587`*^9, 3.558358974287737*^9}, {
   3.558359105221429*^9, 3.5583591337827387`*^9}, 3.558369864400086*^9, 
   3.558435685784788*^9, 3.558508795535699*^9, 3.5588487584515057`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Induktivit\[ADoubleDot]t/Widerstand der Drosselspule\
\>", "Subsubtitle",
 CellChangeTimes->{{3.558508755217391*^9, 3.558508758942493*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"L2", " ", "=", " ", 
  RowBox[{
   FractionBox["1", "CPlatt"], 
   FractionBox[
    RowBox[{"T2", "^", "2"}], 
    RowBox[{
     RowBox[{"4", 
      RowBox[{"\[Pi]", "^", "2"}]}], "+", 
     RowBox[{"LAMBDA2", "^", "2"}]}]]}]}]], "Input",
 CellChangeTimes->{{3.558268129751277*^9, 3.558268139813571*^9}, {
  3.5582695176007633`*^9, 3.558269518606285*^9}, {3.558269695690297*^9, 
  3.558269701169629*^9}, {3.5582701021826*^9, 3.5582701036864567`*^9}, {
  3.558270293153303*^9, 3.558270294792796*^9}}],

Cell[BoxData["12.974322183659192`"], "Output",
 CellChangeTimes->{
  3.558268140406485*^9, {3.558268553130219*^9, 3.5582685612840157`*^9}, {
   3.558268687380183*^9, 3.558268693410843*^9}, {3.558269045678178*^9, 
   3.55826905020634*^9}, 3.5582692927016582`*^9, 3.558269519120318*^9, 
   3.558269702601104*^9, 3.558269761813518*^9, {3.5582698711387663`*^9, 
   3.558269876569209*^9}, {3.558269970700494*^9, 3.558269975149816*^9}, 
   3.558270104068215*^9, 3.55827020660249*^9, {3.5582702953527517`*^9, 
   3.5582702967023067`*^9}, 3.55835745129867*^9, 3.5583575057733917`*^9, 
   3.558358121957925*^9, 3.5583583869347773`*^9, 3.558358463199288*^9, 
   3.558358850568964*^9, {3.558359105274974*^9, 3.558359133829331*^9}, 
   3.5583698644503403`*^9, 3.55843568583617*^9, 3.5585087955851507`*^9, 
   3.558848758499453*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sL2", " ", "=", " ", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "CPlatt"], 
       FractionBox[
        RowBox[{"2", "*", "T2", "*", "sT2"}], 
        RowBox[{
         RowBox[{"4", 
          RowBox[{"\[Pi]", "^", "2"}]}], "+", 
         RowBox[{"LAMBDA2", "^", "2"}]}]]}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["sCPlatt", 
        RowBox[{"CPlatt", "^", "2"}]], 
       FractionBox[
        RowBox[{"T2", "^", "2"}], 
        RowBox[{
         RowBox[{"4", 
          RowBox[{"\[Pi]", "^", "2"}]}], "+", 
         RowBox[{"LAMBDA2", "^", "2"}]}]]}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       FractionBox["1", "CPlatt"], 
       FractionBox[
        RowBox[{
         RowBox[{"T2", "^", "2"}], "*", "2", "*", "LAMBDA2", "*", 
         "sLAMBDA2"}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", 
            RowBox[{"\[Pi]", "^", "2"}]}], "+", 
           RowBox[{"LAMBDA2", "^", "2"}]}], ")"}], "^", "2"}]]}], ")"}], "^", 
     "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.558358989884224*^9, 3.5583590097924433`*^9}, {
  3.5583590762873583`*^9, 3.558359076367075*^9}}],

Cell[BoxData["1.009504970948787`"], "Output",
 CellChangeTimes->{
  3.558359010551746*^9, {3.558359103227623*^9, 3.558359133876616*^9}, 
   3.558369864499589*^9, 3.55843568588422*^9, 3.558508795635418*^9, 
   3.558848758550991*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RL2", " ", "=", " ", 
  RowBox[{
   RowBox[{"LAMBDA2", "/", "T2"}], " ", "*", " ", "2", "*", "L2"}]}]], "Input",\

 CellChangeTimes->{{3.558268193563738*^9, 3.558268199203455*^9}}],

Cell[BoxData["6461.65859264976`"], "Output",
 CellChangeTimes->{
  3.558268199651881*^9, {3.55826855316788*^9, 3.5582685613485823`*^9}, {
   3.558268687412426*^9, 3.5582686934562073`*^9}, {3.558269045723727*^9, 
   3.558269050243738*^9}, 3.558269292734828*^9, 3.558269702638925*^9, 
   3.5582697618807993`*^9, {3.558269871204976*^9, 3.558269876601849*^9}, {
   3.558269970733976*^9, 3.558269975204988*^9}, 3.5582702066520863`*^9, 
   3.55827029674863*^9, 3.558357451371666*^9, 3.558357505880431*^9, 
   3.558358122023609*^9, 3.558358386984713*^9, 3.55835846324879*^9, 
   3.558358850618634*^9, {3.558359105366973*^9, 3.558359133927298*^9}, 
   3.558369864550041*^9, 3.558435685917182*^9, 3.558508795684246*^9, 
   3.558848758599869*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sRL2", " ", "=", " ", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sLAMBDA2", "/", "T2"}], " ", "*", " ", "2", "*", "L2"}], 
      ")"}], "^", "2"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"LAMBDA2", "/", "T2"}], " ", "*", " ", "2", "*", "sL2"}], 
      ")"}], "^", "2"}], " ", "+", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"LAMBDA2", "*", 
       RowBox[{"sT2", "/", 
        RowBox[{"T2", "^", "2"}]}], " ", "*", " ", "2", "*", "L2"}], ")"}], 
     "^", "2"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.5583591132600613`*^9, 3.558359130306622*^9}}],

Cell[BoxData["658.7594043518807`"], "Output",
 CellChangeTimes->{{3.558359131050639*^9, 3.5583591339804068`*^9}, 
   3.558369864599585*^9, 3.558435685965892*^9, 3.558508795732305*^9, 
   3.558848758655099*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"d", "=", "0.0508"}], "\[IndentingNewLine]", 
 RowBox[{"l", "=", "1.0"}]}], "Input",
 CellChangeTimes->{{3.5582689600920563`*^9, 3.558269004915885*^9}, {
   3.5582690445094843`*^9, 3.55826904865982*^9}, 3.55826915786446*^9, {
   3.558269239614286*^9, 3.558269241021759*^9}}],

Cell[BoxData["0.0508`"], "Output",
 CellChangeTimes->{{3.558269151610564*^9, 3.558269158236456*^9}, 
   3.558269241690873*^9, 3.558269292767866*^9, 3.5582697026850243`*^9, 
   3.558269761914115*^9, {3.558269871237875*^9, 3.558269876638603*^9}, {
   3.558269970820112*^9, 3.558269975249571*^9}, 3.558270206701243*^9, 
   3.5582702967979507`*^9, 3.558357451431424*^9, 3.5583575059450893`*^9, 
   3.558358122192925*^9, 3.558358387035604*^9, 3.55835846330107*^9, 
   3.55835885066961*^9, {3.558359105416583*^9, 3.5583591340264683`*^9}, 
   3.5583698646536627`*^9, 3.558435686015745*^9, 3.5585087957829227`*^9, 
   3.558848758716816*^9}],

Cell[BoxData["1.`"], "Output",
 CellChangeTimes->{{3.558269151610564*^9, 3.558269158236456*^9}, 
   3.558269241690873*^9, 3.558269292767866*^9, 3.5582697026850243`*^9, 
   3.558269761914115*^9, {3.558269871237875*^9, 3.558269876638603*^9}, {
   3.558269970820112*^9, 3.558269975249571*^9}, 3.558270206701243*^9, 
   3.5582702967979507`*^9, 3.558357451431424*^9, 3.5583575059450893`*^9, 
   3.558358122192925*^9, 3.558358387035604*^9, 3.55835846330107*^9, 
   3.55835885066961*^9, {3.558359105416583*^9, 3.5583591340264683`*^9}, 
   3.5583698646536627`*^9, 3.558435686015745*^9, 3.5585087957829227`*^9, 
   3.5588487587193003`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Theoretische Induktivit\[ADoubleDot]t der Luftspule\
\>", "Subsubtitle",
 CellChangeTimes->{{3.558508704668894*^9, 3.558508720511395*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"L", " ", "=", " ", 
  RowBox[{
   FractionBox[
    RowBox[{"4", "\[Pi]", "*", 
     SuperscriptBox["2800", "2"], "*", 
     RowBox[{"\[Pi]", "/", "4"}], "*", 
     SuperscriptBox["d", "2"]}], "l"], "*", 
   RowBox[{"10", "^", 
    RowBox[{"-", "7"}]}]}]}]], "Input",
 CellChangeTimes->{{3.558268903934725*^9, 3.558268957942943*^9}, 
   3.558269058683086*^9, {3.5582691243852873`*^9, 3.558269141753776*^9}, 
   3.558269309709301*^9, {3.558269363667528*^9, 3.55826936958375*^9}, 
   3.558269490057765*^9, {3.558435680955339*^9, 3.558435698120987*^9}, 
   3.558436452738578*^9}],

Cell[BoxData["0.019968398386875755`"], "Output",
 CellChangeTimes->{
  3.5582690068398647`*^9, {3.558269045843032*^9, 3.558269059936426*^9}, {
   3.558269121256078*^9, 3.558269161074821*^9}, 3.558269242802885*^9, {
   3.5582692928160257`*^9, 3.558269310399766*^9}, {3.558269365875762*^9, 
   3.558269371206437*^9}, 3.558269491489716*^9, 3.558269702734524*^9, 
   3.558269761963187*^9, {3.558269871274753*^9, 3.55826987668342*^9}, {
   3.558269970865388*^9, 3.558269975299102*^9}, 3.5582702067508297`*^9, 
   3.558270296846459*^9, 3.558357451506372*^9, 3.558357506016234*^9, 
   3.558358122312386*^9, 3.558358387083403*^9, 3.5583584633485537`*^9, 
   3.558358850722817*^9, {3.5583591054655848`*^9, 3.55835913407642*^9}, 
   3.5583698646979837`*^9, {3.558435682775091*^9, 3.5584356987980633`*^9}, 
   3.558436453826805*^9, 3.5585087959262753`*^9, 3.55884875884704*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1173, 655},
WindowMargins->{{Automatic, -334}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 596, 11, 27, "Input"],
Cell[1178, 35, 1052, 15, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2267, 55, 203, 5, 27, "Input"],
Cell[2473, 62, 367, 6, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2877, 73, 642, 10, 27, "Input"],
Cell[3522, 85, 1133, 16, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4692, 106, 751, 19, 27, "Input"],
Cell[5446, 127, 457, 7, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5940, 139, 384, 6, 27, "Input"],
Cell[6327, 147, 967, 14, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7331, 166, 156, 3, 27, "Input"],
Cell[7490, 171, 323, 5, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7850, 181, 484, 9, 27, "Input"],
Cell[8337, 192, 864, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9238, 209, 663, 17, 27, "Input"],
Cell[9904, 228, 410, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10351, 239, 293, 5, 27, "Input"],
Cell[10647, 246, 828, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11512, 263, 161, 3, 27, "Input"],
Cell[11676, 268, 341, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12054, 278, 146, 3, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[12225, 285, 579, 14, 47, "Input"],
Cell[12807, 301, 1057, 15, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13901, 321, 1240, 40, 49, "Input"],
Cell[15144, 363, 332, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15513, 373, 204, 5, 27, "Input"],
Cell[15720, 380, 891, 13, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16648, 398, 678, 20, 27, "Input"],
Cell[17329, 420, 259, 3, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17637, 429, 149, 3, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[17811, 436, 523, 13, 47, "Input"],
Cell[18337, 451, 819, 12, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19193, 468, 1293, 41, 49, "Input"],
Cell[20489, 511, 231, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20757, 520, 204, 5, 27, "Input"],
Cell[20964, 527, 736, 11, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21737, 543, 680, 20, 27, "Input"],
Cell[22420, 565, 209, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22666, 573, 298, 5, 43, "Input"],
Cell[22967, 580, 632, 9, 27, "Output"],
Cell[23602, 591, 630, 9, 27, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24281, 606, 148, 3, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[24454, 613, 599, 14, 49, "Input"],
Cell[25056, 629, 866, 12, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
