(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     10178,        292]
NotebookOptionsPosition[      8951,        243]
NotebookOutlinePosition[      9361,        261]
CellTagsIndexPosition[      9318,        258]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{"R1", " ", ":=", " ", "3.3"}], "\[IndentingNewLine]", 
 RowBox[{"R2", " ", ":=", " ", "985"}], "\[IndentingNewLine]", 
 RowBox[{"R3", " ", ":=", " ", "901"}], "\[IndentingNewLine]", 
 RowBox[{"sigmaR3", " ", ":=", " ", "11.000"}], "\[IndentingNewLine]", 
 RowBox[{"sigmaR2", " ", ":=", "11.000"}], "\[IndentingNewLine]", 
 RowBox[{"sigmaR1", " ", ":=", " ", 
  RowBox[{"3.3", "*", "0.05"}]}]}], "Input",
 CellChangeTimes->{{3.558420863338776*^9, 3.558420880501042*^9}, {
  3.55842096481884*^9, 3.558420966009004*^9}, {3.558421116934704*^9, 
  3.558421127048389*^9}, {3.558421162049211*^9, 3.5584212064686337`*^9}, {
  3.55842128382082*^9, 3.5584212839064207`*^9}, {3.55842209364395*^9, 
  3.558422093693953*^9}, {3.558422224347048*^9, 3.558422260553773*^9}, {
  3.5584228406056967`*^9, 3.5584228558178*^9}}],

Cell[CellGroupData[{

Cell[BoxData["sigmaR1"], "Input",
 CellChangeTimes->{{3.558423435748426*^9, 3.558423437258079*^9}}],

Cell[BoxData["0.165`"], "Output",
 CellChangeTimes->{3.558423437792117*^9, 3.558509445154195*^9, 
  3.5585970536364813`*^9, 3.5585972862125397`*^9, 3.55859738743469*^9, 
  3.55859750481544*^9}]
}, Open  ]],

Cell[BoxData[{
 RowBox[{"U", " ", ":=", " ", "2.01"}], "\[IndentingNewLine]", 
 RowBox[{"sigmaU", " ", ":=", " ", "0.022"}]}], "Input",
 CellChangeTimes->{{3.5584212624149733`*^9, 3.558421267250445*^9}, {
   3.558421347463162*^9, 3.5584213499765377`*^9}, {3.558421424026079*^9, 
   3.55842142622222*^9}, 3.558422093727591*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rg", " ", "=", " ", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"1", "/", "R1"}], "+", 
     RowBox[{"1", "/", "R3"}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.55842121829536*^9, 3.558421241989403*^9}, {
  3.5584220937756233`*^9, 3.558422125839096*^9}}],

Cell[BoxData["3.2879575362158575`"], "Output",
 CellChangeTimes->{{3.558421233524226*^9, 3.558421243270166*^9}, {
   3.5584221321687737`*^9, 3.5584221415672197`*^9}, 3.558422197124655*^9, {
   3.558422262813324*^9, 3.558422292702073*^9}, 3.55842241479615*^9, 
   3.558422551767888*^9, {3.558422846218791*^9, 3.558422857193019*^9}, 
   3.558509445221003*^9, 3.558597053718706*^9, 3.558597286292717*^9, 
   3.5585973875021048`*^9, 3.558597504899352*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sigmaRg", "=", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "R1"], "+", 
      FractionBox["1", "R3"]}], ")"}], 
    RowBox[{"-", "2"}]], 
   SqrtBox[
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["sigmaR1", 
        SuperscriptBox["R1", "2"]], ")"}], "2"], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["sigmaR3", 
        SuperscriptBox["R3", "2"]], ")"}], "2"]}]]}]}]], "Input",
 CellChangeTimes->{{3.558421544045911*^9, 3.558421602187565*^9}, {
  3.55842209382614*^9, 3.558422138493718*^9}, {3.558422212162244*^9, 
  3.5584222149744473`*^9}, {3.558422276567522*^9, 3.558422286371294*^9}}],

Cell[BoxData["0.16379801641014752`"], "Output",
 CellChangeTimes->{
  3.55842160278018*^9, {3.558422132227803*^9, 3.5584221416004553`*^9}, 
   3.558422197163021*^9, {3.558422262851828*^9, 3.558422292739377*^9}, 
   3.558422414862998*^9, 3.5584225518055763`*^9, {3.5584228462545147`*^9, 
   3.5584228572316647`*^9}, 3.558509445285397*^9, 3.5585970537686443`*^9, 
   3.558597286338765*^9, 3.558597387541704*^9, 3.558597504952591*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Ig", " ", "=", " ", 
  FractionBox["U", 
   RowBox[{"Rg", "+", "R2"}]]}]], "Input",
 CellChangeTimes->{{3.558421248714589*^9, 3.558421250643073*^9}, {
  3.558421457831381*^9, 3.55842148834863*^9}, {3.558422093195656*^9, 
  3.558422125888714*^9}, {3.558422173004376*^9, 3.558422173259939*^9}}],

Cell[BoxData["0.0020338201884103633`"], "Output",
 CellChangeTimes->{{3.5584214634985933`*^9, 3.5584214911273537`*^9}, 
   3.558421608955913*^9, {3.558422132268445*^9, 3.558422141649776*^9}, {
   3.5584221739625607`*^9, 3.5584221972092113`*^9}, {3.558422262879713*^9, 
   3.558422292768132*^9}, 3.558422414896225*^9, 3.5584225518354273`*^9, {
   3.558422846284779*^9, 3.558422857277369*^9}, 3.558509445323964*^9, 
   3.558597053821516*^9, 3.558597286412179*^9, 3.558597387588873*^9, 
   3.5585975050013943`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sigmaIg", "=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"sigmaR2", " ", "U"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"R2", "+", "Rg"}], ")"}], "2"]], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"sigmaRg", " ", "U"}], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"R2", "+", "Rg"}], ")"}], "2"]], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["sigmaU", 
       RowBox[{"R2", "+", "Rg"}]], ")"}], "2"]}]]}]], "Input",
 CellChangeTimes->{{3.558421499595928*^9, 3.558421540310657*^9}, {
  3.558421968945077*^9, 3.5584219732065277`*^9}, {3.55842209326589*^9, 
  3.558422125823217*^9}, {3.5584221574874697`*^9, 3.558422164558818*^9}}],

Cell[BoxData["0.00003175049200055201`"], "Output",
 CellChangeTimes->{
  3.5584215166997766`*^9, {3.558421606911932*^9, 3.558421611196474*^9}, {
   3.558422132307558*^9, 3.558422141715543*^9}, {3.558422175289831*^9, 
   3.558422197258191*^9}, {3.5584222629469233`*^9, 3.558422292806428*^9}, 
   3.5584224149327793`*^9, 3.558422551867137*^9, {3.558422846317679*^9, 
   3.558422857342781*^9}, 3.5585094453608913`*^9, 3.5585970538700037`*^9, 
   3.55859728645123*^9, 3.5585973876370707`*^9, 3.558597505060687*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integratorstrom", "Subsubtitle",
 CellChangeTimes->{{3.558509450469615*^9, 3.5585094529475527`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Iint", " ", "=", " ", 
  FractionBox["Ig", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["R3", "R1"], "+", "1"}], ")"}]]}]], "Input",
 CellChangeTimes->{{3.558421861992811*^9, 3.558421885155492*^9}, {
  3.558422093447073*^9, 3.55842210355593*^9}, {3.5584221685368023`*^9, 
  3.558422168772171*^9}, {3.55842248430599*^9, 3.558422490201602*^9}, {
  3.558422545494772*^9, 3.558422545754768*^9}, {3.5585387780490437`*^9, 
  3.558538791359871*^9}, {3.558538879626019*^9, 3.558538908214077*^9}, {
  3.558597244330017*^9, 3.558597250392604*^9}}],

Cell[BoxData["7.421880594663495`*^-6"], "Output",
 CellChangeTimes->{3.558538908664238*^9, 3.558597053919785*^9, 
  3.5585972509582443`*^9, 3.558597286486546*^9, 3.558597387689218*^9, 
  3.558597505129105*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.558538902967515*^9, 3.558538904296215*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sigmaIint", "=", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Ig", " ", "R3", " ", "sigmaR1"}], 
       RowBox[{
        SuperscriptBox["R1", "2"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["R3", "R1"], "+", "1"}], ")"}], "2"]}]], ")"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"Ig", " ", "sigmaR3"}], 
       RowBox[{"R1", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["R3", "R1"], "+", "1"}], ")"}], "2"]}]], ")"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["sigmaIg", 
       RowBox[{
        FractionBox["R3", "R1"], "+", "1"}]], ")"}], "2"]}]]}]], "Input",
 CellChangeTimes->{{3.5584218888586187`*^9, 3.558421963798204*^9}, {
  3.558422093481332*^9, 3.55842210365611*^9}, {3.558422152716344*^9, 
  3.5584221904068213`*^9}, {3.558597280060237*^9, 3.5585972803140793`*^9}, {
  3.5585974725870047`*^9, 3.55859747380628*^9}}],

Cell[BoxData["3.9784768966461536`*^-7"], "Output",
 CellChangeTimes->{
  3.55842194963328*^9, {3.558422132418127*^9, 3.558422141786469*^9}, {
   3.5584221917452927`*^9, 3.5584221973745737`*^9}, {3.558422263012796*^9, 
   3.558422292887517*^9}, 3.558422414999699*^9, 3.5584225519355087`*^9, {
   3.5584228464168053`*^9, 3.558422857425644*^9}, 3.5585094454387083`*^9, 
   3.558597053999958*^9, {3.5585972814510393`*^9, 3.558597286561378*^9}, {
   3.558597385509893*^9, 3.558597387783733*^9}, 3.558597505194558*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{Automatic, -226}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 831, 13, 103, "Input"],
Cell[CellGroupData[{
Cell[1413, 37, 99, 1, 27, "Input"],
Cell[1515, 40, 193, 3, 27, "Output"]
}, Open  ]],
Cell[1723, 46, 326, 5, 43, "Input"],
Cell[CellGroupData[{
Cell[2074, 55, 302, 8, 27, "Input"],
Cell[2379, 65, 451, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2867, 76, 704, 21, 65, "Input"],
Cell[3574, 99, 431, 6, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4042, 110, 316, 6, 48, "Input"],
Cell[4361, 118, 511, 7, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4909, 130, 828, 24, 66, "Input"],
Cell[5740, 156, 510, 7, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6287, 168, 106, 1, 26, "Subsubtitle"],
Cell[CellGroupData[{
Cell[6418, 173, 564, 11, 56, "Input"],
Cell[6985, 186, 209, 3, 30, "Output"]
}, Open  ]],
Cell[7209, 192, 92, 1, 27, "Input"],
Cell[CellGroupData[{
Cell[7326, 197, 1082, 33, 78, "Input"],
Cell[8411, 232, 512, 7, 30, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
