(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     22855,        727]
NotebookOptionsPosition[     20525,        641]
NotebookOutlinePosition[     20880,        657]
CellTagsIndexPosition[     20837,        654]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{"a", ":=", "0.381733"}], "\n", 
 RowBox[{"sa", ":=", "0.003288"}], "\n", 
 RowBox[{"c", ":=", "0.0173121"}], "\n", 
 RowBox[{"sc", ":=", "0.0009222"}], "\n", 
 RowBox[{"d", ":=", 
  RowBox[{"-", "0.00109558"}]}], "\n", 
 RowBox[{"sd", ":=", 
  FractionBox["7.722", 
   SuperscriptBox["10", "5"]]}], "\n", 
 RowBox[{"e", ":=", 
  FractionBox["2.52385", 
   SuperscriptBox["10", "5"]]}], "\n", 
 RowBox[{"se", ":=", 
  FractionBox["2.529", 
   SuperscriptBox["10", "6"]]}], "\n", 
 RowBox[{"f", ":=", 
  RowBox[{"-", 
   FractionBox["2.71581", 
    SuperscriptBox["10", "7"]]}]}], "\n", 
 RowBox[{"sf", ":=", 
  FractionBox["3.526", 
   SuperscriptBox["10", "8"]]}], "\n", 
 RowBox[{"g", ":=", 
  FractionBox["1.10423", 
   SuperscriptBox["10", "9"]]}], "\n", 
 RowBox[{"sg", ":=", 
  FractionBox["1.754", 
   SuperscriptBox["10", "10"]]}]}], "Input",
 CellChangeTimes->{{3.556187750457003*^9, 3.556187955222763*^9}, {
  3.556188101887738*^9, 3.556188113740931*^9}, {3.556188253601255*^9, 
  3.556188256328567*^9}, {3.556195136604007*^9, 3.556195161429039*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BField", "[", "x_", "]"}], ":=", " ", 
  RowBox[{"a", "+", 
   RowBox[{"c", "*", "x"}], "+", 
   RowBox[{"d", "*", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"e", "*", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"f", "*", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"g", "*", 
    SuperscriptBox["x", "5"]}]}]}]], "Input",
 CellChangeTimes->{{3.556188124179881*^9, 3.5561882012482443`*^9}, {
  3.556194015936983*^9, 3.5561940163204613`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GradB", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{"c", "+", 
   RowBox[{"2", "*", "d", "*", "x"}], "+", 
   RowBox[{"3", "*", "e", "*", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"4", "*", "f", "*", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"5", "*", "g", "*", 
    SuperscriptBox["x", "4"]}]}]}]], "Input",
 CellChangeTimes->{{3.5561882046788397`*^9, 3.556188219431212*^9}, {
   3.5561883784470882`*^9, 3.556188382219317*^9}, {3.556194045155702*^9, 
   3.556194065823834*^9}, 3.55619478248656*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"BG", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"BField", "[", "x", "]"}], "*", 
   RowBox[{"GradB", "[", "x", "]"}], "*", "1000"}]}]], "Input",
 CellChangeTimes->{{3.5561882228106947`*^9, 3.55618825168576*^9}, {
  3.556188307660643*^9, 3.556188326724197*^9}, {3.5561883755606194`*^9, 
  3.5561883805864477`*^9}, {3.5561884113648167`*^9, 3.5561884252739*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BGa", "[", "x_", "]"}], " ", "=", 
  RowBox[{"1000", " ", 
   RowBox[{"(", 
    RowBox[{"c", "+", 
     RowBox[{"2", " ", "d", " ", "x"}], "+", 
     RowBox[{"3", " ", "e", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"4", " ", "f", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"5", " ", "g", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5561944765578413`*^9, 3.556194478661138*^9}, {
   3.556194556394601*^9, 3.556194577459416*^9}, 3.5561946788431997`*^9, {
   3.556194793155398*^9, 3.556194794999227*^9}}],

Cell[BoxData[
 RowBox[{"1000", " ", 
  RowBox[{"(", 
   RowBox[{"0.0173121`", "\[VeryThinSpace]", "-", 
    RowBox[{"0.00219116`", " ", "x"}], "+", 
    RowBox[{"0.00007571550000000001`", " ", 
     SuperscriptBox["x", "2"]}], "-", 
    RowBox[{"1.086324`*^-6", " ", 
     SuperscriptBox["x", "3"]}], "+", 
    RowBox[{"5.52115`*^-9", " ", 
     SuperscriptBox["x", "4"]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.556194714159946*^9, 3.556194722662499*^9}, {
   3.556194788400013*^9, 3.556194797914462*^9}, 3.5561949031707077`*^9, {
   3.556195219274194*^9, 3.556195222658556*^9}, 3.556195629023831*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BGc", "[", "x_", "]"}], " ", "=", 
  RowBox[{
   RowBox[{"1000", " ", "x", " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"2", " ", "d", " ", "x"}], "+", 
      RowBox[{"3", " ", "e", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"4", " ", "f", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"5", " ", "g", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
   RowBox[{"1000", " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"g", " ", 
       SuperscriptBox["x", "5"]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.556194600537881*^9, 3.556194620209296*^9}, 
   3.556194684499563*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"1000", " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"0.0173121`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.00219116`", " ", "x"}], "+", 
     RowBox[{"0.00007571550000000001`", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"1.086324`*^-6", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"5.52115`*^-9", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
  RowBox[{"1000", " ", 
   RowBox[{"(", 
    RowBox[{"0.381733`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.0173121`", " ", "x"}], "-", 
     RowBox[{"0.00109558`", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"0.000025238500000000002`", " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"2.71581`*^-7", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"1.10423`*^-9", " ", 
      SuperscriptBox["x", "5"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.556194712632547*^9, 3.556194722761382*^9}, 
   3.556194906341498*^9, {3.556195219326233*^9, 3.556195222716154*^9}, 
   3.556195629096491*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"BGd", "[", "x_", "]"}], " ", "=", 
   RowBox[{
    RowBox[{"1000", " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"c", "+", 
       RowBox[{"2", " ", "d", " ", "x"}], "+", 
       RowBox[{"3", " ", "e", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"4", " ", "f", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"5", " ", "g", " ", 
        SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
    RowBox[{"2000", " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"c", " ", "x"}], "+", 
       RowBox[{"d", " ", 
        SuperscriptBox["x", "2"]}], "+", 
       RowBox[{"e", " ", 
        SuperscriptBox["x", "3"]}], "+", 
       RowBox[{"f", " ", 
        SuperscriptBox["x", "4"]}], "+", 
       RowBox[{"g", " ", 
        SuperscriptBox["x", "5"]}]}], ")"}]}]}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.5561945933244133`*^9, 3.556194623524139*^9}, 
   3.556194689395299*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"1000", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"0.0173121`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.00219116`", " ", "x"}], "+", 
     RowBox[{"0.00007571550000000001`", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"1.086324`*^-6", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"5.52115`*^-9", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
  RowBox[{"2000", " ", "x", " ", 
   RowBox[{"(", 
    RowBox[{"0.381733`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.0173121`", " ", "x"}], "-", 
     RowBox[{"0.00109558`", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"0.000025238500000000002`", " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"2.71581`*^-7", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"1.10423`*^-9", " ", 
      SuperscriptBox["x", "5"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.556194710988619*^9, 3.556194722832265*^9}, 
   3.556194910711926*^9, {3.556195219379162*^9, 3.5561952227638063`*^9}, 
   3.556195629144354*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BGe", "[", "x_", "]"}], " ", "=", 
  RowBox[{
   RowBox[{"1000", " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"2", " ", "d", " ", "x"}], "+", 
      RowBox[{"3", " ", "e", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"4", " ", "f", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"5", " ", "g", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
   RowBox[{"3000", " ", 
    SuperscriptBox["x", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"g", " ", 
       SuperscriptBox["x", "5"]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.5561946050902042`*^9, 3.5561946259616327`*^9}, 
   3.556194693604575*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"1000", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"0.0173121`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.00219116`", " ", "x"}], "+", 
     RowBox[{"0.00007571550000000001`", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"1.086324`*^-6", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"5.52115`*^-9", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
  RowBox[{"3000", " ", 
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"0.381733`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.0173121`", " ", "x"}], "-", 
     RowBox[{"0.00109558`", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"0.000025238500000000002`", " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"2.71581`*^-7", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"1.10423`*^-9", " ", 
      SuperscriptBox["x", "5"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.556194709295353*^9, 3.5561947229099693`*^9}, 
   3.556194913665121*^9, {3.556195219475347*^9, 3.556195222815638*^9}, 
   3.556195629194297*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BGf", "[", "x_", "]"}], " ", "=", 
  RowBox[{
   RowBox[{"1000", " ", 
    SuperscriptBox["x", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"2", " ", "d", " ", "x"}], "+", 
      RowBox[{"3", " ", "e", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"4", " ", "f", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"5", " ", "g", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
   RowBox[{"4000", " ", 
    SuperscriptBox["x", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"g", " ", 
       SuperscriptBox["x", "5"]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.55619460663381*^9, 3.556194628984509*^9}, 
   3.5561946984206467`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"1000", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"0.0173121`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.00219116`", " ", "x"}], "+", 
     RowBox[{"0.00007571550000000001`", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"1.086324`*^-6", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"5.52115`*^-9", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
  RowBox[{"4000", " ", 
   SuperscriptBox["x", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"0.381733`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.0173121`", " ", "x"}], "-", 
     RowBox[{"0.00109558`", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"0.000025238500000000002`", " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"2.71581`*^-7", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"1.10423`*^-9", " ", 
      SuperscriptBox["x", "5"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.556194707700242*^9, 3.556194722965397*^9}, 
   3.556194921423192*^9, {3.556195219525338*^9, 3.556195222892864*^9}, 
   3.5561956292443132`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"BGg", "[", "x_", "]"}], " ", "=", 
  RowBox[{
   RowBox[{"1000", " ", 
    SuperscriptBox["x", "5"], " ", 
    RowBox[{"(", 
     RowBox[{"c", "+", 
      RowBox[{"2", " ", "d", " ", "x"}], "+", 
      RowBox[{"3", " ", "e", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"4", " ", "f", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"5", " ", "g", " ", 
       SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
   RowBox[{"5000", " ", 
    SuperscriptBox["x", "4"], " ", 
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"c", " ", "x"}], "+", 
      RowBox[{"d", " ", 
       SuperscriptBox["x", "2"]}], "+", 
      RowBox[{"e", " ", 
       SuperscriptBox["x", "3"]}], "+", 
      RowBox[{"f", " ", 
       SuperscriptBox["x", "4"]}], "+", 
      RowBox[{"g", " ", 
       SuperscriptBox["x", "5"]}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.556194608097625*^9, 3.55619463190582*^9}, 
   3.556194703027315*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"1000", " ", 
   SuperscriptBox["x", "5"], " ", 
   RowBox[{"(", 
    RowBox[{"0.0173121`", "\[VeryThinSpace]", "-", 
     RowBox[{"0.00219116`", " ", "x"}], "+", 
     RowBox[{"0.00007571550000000001`", " ", 
      SuperscriptBox["x", "2"]}], "-", 
     RowBox[{"1.086324`*^-6", " ", 
      SuperscriptBox["x", "3"]}], "+", 
     RowBox[{"5.52115`*^-9", " ", 
      SuperscriptBox["x", "4"]}]}], ")"}]}], "+", 
  RowBox[{"5000", " ", 
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"0.381733`", "\[VeryThinSpace]", "+", 
     RowBox[{"0.0173121`", " ", "x"}], "-", 
     RowBox[{"0.00109558`", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"0.000025238500000000002`", " ", 
      SuperscriptBox["x", "3"]}], "-", 
     RowBox[{"2.71581`*^-7", " ", 
      SuperscriptBox["x", "4"]}], "+", 
     RowBox[{"1.10423`*^-9", " ", 
      SuperscriptBox["x", "5"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{{3.556194703897503*^9, 3.556194723042562*^9}, 
   3.556194924073968*^9, {3.5561952195735273`*^9, 3.556195222948254*^9}, 
   3.556195629294839*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"sBG", "[", 
   RowBox[{"x0_", ",", "sx0_"}], "]"}], ":=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{"BG", "[", "x", "]"}], ",", "x"}], "]"}], "/.", 
         RowBox[{"x", "\[Rule]", "x0"}]}], ")"}], "*", "sx0"}], ")"}], "2"], 
    "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BGa", "[", "x0", "]"}], "*", "sa"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BGc", "[", "x0", "]"}], "*", "sc"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BGd", "[", "x0", "]"}], "*", "sd"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BGe", "[", "x0", "]"}], "*", "se"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BGf", "[", "x0", "]"}], "*", "sf"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BGg", "[", "x0", "]"}], "*", "sg"}], ")"}], "2"]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.5561949354770927`*^9, 3.556194980163307*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BGg", "[", "67.5", "]"}]], "Input",
 CellChangeTimes->{{3.5561952470006332`*^9, 3.556195274527321*^9}}],

Cell[BoxData["1.6741672279824684`*^10"], "Output",
 CellChangeTimes->{{3.556195252978346*^9, 3.556195274947955*^9}, 
   3.556195629372954*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BG", "[", "67.5", "]"}]], "Input",
 CellChangeTimes->{{3.556194701278804*^9, 3.556194701306137*^9}, {
  3.556194761790379*^9, 3.556194767485681*^9}}],

Cell[BoxData[
 RowBox[{"-", "1.171384336667116`"}]], "Output",
 CellChangeTimes->{{3.55619476310898*^9, 3.556194771877939*^9}, 
   3.556195014905345*^9, {3.556195219653675*^9, 3.556195223024067*^9}, 
   3.5561956294289303`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBG", "[", 
  RowBox[{"67.5", ",", "0.1957890021"}], "]"}]], "Input",
 CellChangeTimes->{{3.5561949833479977`*^9, 3.556194999880891*^9}}],

Cell[BoxData["8.0003504083207`"], "Output",
 CellChangeTimes->{{3.5561950006237087`*^9, 3.556195020547372*^9}, 
   3.55619517855774*^9, {3.556195219705866*^9, 3.556195223076565*^9}, 
   3.55619537165277*^9, 3.556195629463895*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"8.0003504083207`", "/", 
  RowBox[{"-", "1.17138"}]}]], "Input",
 CellChangeTimes->{{3.556195846593542*^9, 3.556195850802836*^9}}],

Cell[BoxData[
 RowBox[{"-", "6.829850610664942`"}]], "Output",
 CellChangeTimes->{3.556195851475986*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"BG", "[", "x", "]"}], ",", "x"}], "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "67.5"}]}], ")"}], "*", "0.1957890021"}]], "Input",\

 CellChangeTimes->{{3.556195620872189*^9, 3.556195633743044*^9}}],

Cell[BoxData["0.0038964226503628912`"], "Output",
 CellChangeTimes->{3.556195634356531*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BG", "[", "37.3", "]"}]], "Input",
 CellChangeTimes->{{3.556189501234865*^9, 3.556189503771879*^9}}],

Cell[BoxData[
 RowBox[{"-", "1.7482093339301246`"}]], "Output",
 CellChangeTimes->{
  3.556189504424287*^9, 3.55619472315893*^9, {3.5561952197571983`*^9, 
   3.5561952231290417`*^9}, 3.556195629537839*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBG", "[", 
  RowBox[{"37.3", ",", "0.1290994449"}], "]"}]], "Input",
 CellChangeTimes->{{3.556195438276211*^9, 3.556195446963222*^9}}],

Cell[BoxData["4.363796415034291`"], "Output",
 CellChangeTimes->{3.556195448617818*^9, 3.556195629580845*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"BG", "[", "x", "]"}], ",", "x"}], "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "37.3"}]}], ")"}], "*", "0.1290994449"}]], "Input",\

 CellChangeTimes->{{3.5561895250553427`*^9, 3.5561895333155518`*^9}, {
  3.556195434737114*^9, 3.556195444573394*^9}, {3.55619560089645*^9, 
  3.556195636013682*^9}}],

Cell[BoxData["0.006204533216273065`"], "Output",
 CellChangeTimes->{3.5561956363504143`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BG", "[", "37.025", "]"}]], "Input",
 CellChangeTimes->{{3.55618921711257*^9, 3.556189229547173*^9}}],

Cell[BoxData[
 RowBox[{"-", "1.7614544103174197`"}]], "Output",
 CellChangeTimes->{
  3.556189230016416*^9, 3.556194723248432*^9, {3.556195219855505*^9, 
   3.556195223229725*^9}, 3.556195629657029*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sBG", "[", 
  RowBox[{"37.025", ",", "0.1701714821"}], "]"}]], "Input",
 CellChangeTimes->{{3.556195459395926*^9, 3.556195469499302*^9}}],

Cell[BoxData["4.315005940099423`"], "Output",
 CellChangeTimes->{3.556195469984733*^9, 3.556195629710327*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"BG", "[", "x", "]"}], ",", "x"}], "]"}], "/.", 
    RowBox[{"x", "\[Rule]", "37.025"}]}], ")"}], "*", 
  "0.1701714821"}]], "Input",
 CellChangeTimes->{{3.556189266698806*^9, 3.556189274901554*^9}}],

Cell[BoxData["0.008212534562804448`"], "Output",
 CellChangeTimes->{
  3.556189275730082*^9, 3.556194723294559*^9, {3.556195219908687*^9, 
   3.5561952232768307`*^9}, 3.5561956297569323`*^9}]
}, Open  ]]
},
WindowSize->{740, 652},
WindowMargins->{{186, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1083, 31, 359, "Input"],
Cell[1643, 53, 495, 14, 30, "Input"],
Cell[2141, 69, 551, 13, 30, "Input"],
Cell[2695, 84, 398, 8, 27, "Input"],
Cell[CellGroupData[{
Cell[3118, 96, 610, 15, 33, "Input"],
Cell[3731, 113, 607, 13, 33, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4375, 131, 922, 27, 33, "Input"],
Cell[5300, 160, 1050, 26, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6387, 191, 1024, 30, 49, "Input"],
Cell[7414, 223, 1087, 27, 53, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8538, 255, 988, 29, 33, "Input"],
Cell[9529, 286, 1112, 28, 71, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10678, 319, 985, 29, 33, "Input"],
Cell[11666, 350, 1112, 28, 71, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12815, 383, 983, 29, 33, "Input"],
Cell[13801, 414, 1112, 28, 71, "Output"]
}, Open  ]],
Cell[14928, 445, 1267, 41, 68, "Input"],
Cell[CellGroupData[{
Cell[16220, 490, 127, 2, 27, "Input"],
Cell[16350, 494, 142, 2, 30, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16529, 501, 173, 3, 27, InheritFromParent],
Cell[16705, 506, 227, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16969, 515, 161, 3, 27, "Input"],
Cell[17133, 520, 229, 3, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17399, 528, 154, 3, 27, "Input"],
Cell[17556, 533, 104, 2, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17697, 540, 299, 9, 27, "Input"],
Cell[17999, 551, 91, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18127, 557, 124, 2, 27, "Input"],
Cell[18254, 561, 205, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18496, 570, 159, 3, 27, "Input"],
Cell[18658, 575, 109, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18804, 581, 400, 11, 27, "Input"],
Cell[19207, 594, 92, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19336, 600, 125, 2, 27, "Input"],
Cell[19464, 604, 202, 4, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19703, 613, 161, 3, 27, "Input"],
Cell[19867, 618, 109, 1, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20013, 624, 302, 9, 27, "Input"],
Cell[20318, 635, 191, 3, 27, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
